/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="XlaVariadicReduceV2", inputsClass=Inputs.class)
public final class XlaVariadicReduce
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "XlaVariadicReduceV2";
    private List<Output<?>> outputs;

    public XlaVariadicReduce(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputsLength = operation.outputListLength("outputs");
        this.outputs = Arrays.asList(operation.outputList(outputIdx, outputsLength));
        outputIdx += outputsLength;
    }

    public static XlaVariadicReduce create(Scope scope, Iterable<Operand<?>> inputs, Iterable<Operand<?>> initValues, List<Long> dimensionsToReduce, ConcreteFunction reducer) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "XlaVariadicReduce");
        opBuilder.addInputList(Operands.asOutputs(inputs));
        opBuilder.addInputList(Operands.asOutputs(initValues));
        long[] dimensionsToReduceArray = new long[dimensionsToReduce.size()];
        for (int i = 0; i < dimensionsToReduceArray.length; ++i) {
            dimensionsToReduceArray[i] = dimensionsToReduce.get(i);
        }
        opBuilder.setAttr("dimensions_to_reduce", dimensionsToReduceArray);
        opBuilder.setAttr("reducer", reducer);
        return new XlaVariadicReduce(opBuilder.build());
    }

    public List<Output<?>> outputs() {
        return this.outputs;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.outputs.iterator();
    }

    @OpInputsMetadata(outputsClass=XlaVariadicReduce.class)
    public static class Inputs
    extends RawOpInputs<XlaVariadicReduce> {
        public final Iterable<Operand<?>> inputs;
        public final Iterable<Operand<?>> initValues;
        public final DataType[] T;
        public final long[] dimensionsToReduce;

        public Inputs(GraphOperation op) {
            super(new XlaVariadicReduce(op), op, Arrays.asList("T", "dimensions_to_reduce"));
            int inputIndex = 0;
            int inputsLength = op.inputListLength("inputs");
            this.inputs = Arrays.asList((Operand[])op.inputList(inputIndex, inputsLength));
            int initValuesLength = op.inputListLength("init_values");
            this.initValues = Arrays.asList((Operand[])op.inputList(inputIndex += inputsLength, initValuesLength));
            inputIndex += initValuesLength;
            this.T = op.attributes().getAttrTypeList("T");
            this.dimensionsToReduce = op.attributes().getAttrIntList("dimensions_to_reduce");
        }
    }
}

