/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="Placeholder", inputsClass=Inputs.class)
public final class Placeholder<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "Placeholder";
    private Output<T> output;

    public Placeholder(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> Placeholder<T> create(Scope scope, Class<T> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.shape == null) continue;
                opBuilder.setAttr("shape", opts.shape);
            }
        }
        return new Placeholder<T>(opBuilder.build());
    }

    public static Options shape(Shape shape) {
        return new Options().shape(shape);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=Placeholder.class)
    public static class Inputs
    extends RawOpInputs<Placeholder<?>> {
        public final DataType dtype;
        public final Shape shape;

        public Inputs(GraphOperation op) {
            super(new Placeholder(op), op, Arrays.asList("dtype", "shape"));
            boolean inputIndex = false;
            this.dtype = op.attributes().getAttrType("dtype");
            this.shape = op.attributes().getAttrShape("shape");
        }
    }

    public static class Options {
        private Shape shape;

        private Options() {
        }

        public Options shape(Shape shape) {
            this.shape = shape;
            return this;
        }
    }
}

