/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.types;

import java.util.function.Consumer;
import org.tensorflow.SparseTensor;
import org.tensorflow.Tensor;
import org.tensorflow.internal.types.TInt64Mapper;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.StdArrays;
import org.tensorflow.ndarray.buffer.LongDataBuffer;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.annotation.TensorType;
import org.tensorflow.types.family.TIntegral;

@TensorType(dataType=DataType.DT_INT64, byteSize=8, mapperClass=TInt64Mapper.class)
public interface TInt64
extends LongNdArray,
TIntegral {
    public static TInt64 scalarOf(long value) {
        return Tensor.of(TInt64.class, Shape.scalar(), (T data) -> data.setLong(value, new long[0]));
    }

    public static TInt64 vectorOf(long ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        return Tensor.of(TInt64.class, Shape.of(values.length), (T data) -> StdArrays.copyTo(values, (LongNdArray)data));
    }

    public static TInt64 tensorOf(NdArray<Long> src) {
        return Tensor.of(TInt64.class, src.shape(), src::copyTo);
    }

    public static TInt64 tensorOf(Shape shape) {
        return Tensor.of(TInt64.class, shape);
    }

    public static TInt64 tensorOf(Shape shape, LongDataBuffer data) {
        return Tensor.of(TInt64.class, shape, (T d) -> d.write(data));
    }

    public static TInt64 tensorOf(Shape shape, Consumer<TInt64> dataInit) {
        return Tensor.of(TInt64.class, shape, dataInit);
    }

    public static TInt64 sparseTensorOf(TInt64 indices, TInt64 values, TInt64 denseShape) {
        return SparseTensor.of(indices, values, denseShape).asTypedTensor();
    }
}

