/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.ragged;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="RaggedTensorToSparse", inputsClass=Inputs.class)
public final class RaggedTensorToSparse<U extends TType>
extends RawOp {
    public static final String OP_NAME = "RaggedTensorToSparse";
    private Output<TInt64> sparseIndices;
    private Output<U> sparseValues;
    private Output<TInt64> sparseDenseShape;

    public RaggedTensorToSparse(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.sparseIndices = operation.output(outputIdx++);
        this.sparseValues = operation.output(outputIdx++);
        this.sparseDenseShape = operation.output(outputIdx++);
    }

    public static <U extends TType> RaggedTensorToSparse<U> create(Scope scope, Iterable<Operand<? extends TNumber>> rtNestedSplits, Operand<U> rtDenseValues) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(rtNestedSplits));
        opBuilder.addInput(rtDenseValues.asOutput());
        return new RaggedTensorToSparse<U>(opBuilder.build());
    }

    public Output<TInt64> sparseIndices() {
        return this.sparseIndices;
    }

    public Output<U> sparseValues() {
        return this.sparseValues;
    }

    public Output<TInt64> sparseDenseShape() {
        return this.sparseDenseShape;
    }

    @OpInputsMetadata(outputsClass=RaggedTensorToSparse.class)
    public static class Inputs<U extends TType>
    extends RawOpInputs<RaggedTensorToSparse<U>> {
        public final Iterable<Operand<? extends TNumber>> rtNestedSplits;
        public final Operand<U> rtDenseValues;
        public final DataType T;
        public final DataType Tsplits;

        public Inputs(GraphOperation op) {
            super(new RaggedTensorToSparse(op), op, Arrays.asList("T", "Tsplits"));
            int inputIndex = 0;
            int rtNestedSplitsLength = op.inputListLength("rt_nested_splits");
            this.rtNestedSplits = Arrays.asList((Operand[])op.inputList(inputIndex, rtNestedSplitsLength));
            inputIndex += rtNestedSplitsLength;
            this.rtDenseValues = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.Tsplits = op.attributes().getAttrType("Tsplits");
        }
    }
}

