/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.summary;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SummaryWriter", inputsClass=Inputs.class)
public final class SummaryWriter
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "SummaryWriter";
    private Output<? extends TType> writer;

    public SummaryWriter(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.writer = operation.output(outputIdx++);
    }

    public static SummaryWriter create(Scope scope, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        if (options != null) {
            for (Options opts : options) {
                if (opts.sharedName != null) {
                    opBuilder.setAttr("shared_name", opts.sharedName);
                }
                if (opts.container == null) continue;
                opBuilder.setAttr("container", opts.container);
            }
        }
        return new SummaryWriter(opBuilder.build());
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public Output<? extends TType> writer() {
        return this.writer;
    }

    @Override
    public Output<TType> asOutput() {
        return this.writer;
    }

    @OpInputsMetadata(outputsClass=SummaryWriter.class)
    public static class Inputs
    extends RawOpInputs<SummaryWriter> {
        public final String sharedName;
        public final String container;

        public Inputs(GraphOperation op) {
            super(new SummaryWriter(op), op, Arrays.asList("shared_name", "container"));
            boolean inputIndex = false;
            this.sharedName = op.attributes().getAttrString("shared_name");
            this.container = op.attributes().getAttrString("container");
        }
    }

    public static class Options {
        private String sharedName;
        private String container;

        private Options() {
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }
    }
}

