/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="CSRSparseMatrixToDense", inputsClass=Inputs.class)
public final class CSRSparseMatrixToDense<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "CSRSparseMatrixToDense";
    private Output<T> denseOutput;

    public CSRSparseMatrixToDense(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.denseOutput = operation.output(outputIdx++);
    }

    public static <T extends TType> CSRSparseMatrixToDense<T> create(Scope scope, Operand<? extends TType> sparseInput, Class<T> type) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(sparseInput.asOutput());
        opBuilder.setAttr("type", Operands.toDataType(type));
        return new CSRSparseMatrixToDense<T>(opBuilder.build());
    }

    public Output<T> denseOutput() {
        return this.denseOutput;
    }

    @Override
    public Output<T> asOutput() {
        return this.denseOutput;
    }

    @OpInputsMetadata(outputsClass=CSRSparseMatrixToDense.class)
    public static class Inputs
    extends RawOpInputs<CSRSparseMatrixToDense<?>> {
        public final Operand<? extends TType> sparseInput;
        public final DataType type;

        public Inputs(GraphOperation op) {
            super(new CSRSparseMatrixToDense(op), op, Arrays.asList("type"));
            int inputIndex = 0;
            this.sparseInput = op.input(inputIndex++);
            this.type = op.attributes().getAttrType("type");
        }
    }
}

