/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.TString;
import org.tensorflow.types.TUint8;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="DecodePng", inputsClass=Inputs.class)
public final class DecodePng<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "DecodePng";
    private Output<T> image;

    public DecodePng(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.image = operation.output(outputIdx++);
    }

    public static <T extends TNumber> DecodePng<T> create(Scope scope, Operand<TString> contents, Class<T> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(contents.asOutput());
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.channels == null) continue;
                opBuilder.setAttr("channels", opts.channels);
            }
        }
        return new DecodePng<T>(opBuilder.build());
    }

    public static DecodePng<TUint8> create(Scope scope, Operand<TString> contents, Options[] options) {
        return DecodePng.create(scope, contents, TUint8.class, options);
    }

    public static Options channels(Long channels) {
        return new Options().channels(channels);
    }

    public Output<T> image() {
        return this.image;
    }

    @Override
    public Output<T> asOutput() {
        return this.image;
    }

    @OpInputsMetadata(outputsClass=DecodePng.class)
    public static class Inputs
    extends RawOpInputs<DecodePng<?>> {
        public final Operand<TString> contents;
        public final long channels;
        public final DataType dtype;

        public Inputs(GraphOperation op) {
            super(new DecodePng(op), op, Arrays.asList("channels", "dtype"));
            int inputIndex = 0;
            this.contents = op.input(inputIndex++);
            this.channels = op.attributes().getAttrInt("channels");
            this.dtype = op.attributes().getAttrType("dtype");
        }
    }

    public static class Options {
        private Long channels;

        private Options() {
        }

        public Options channels(Long channels) {
            this.channels = channels;
            return this;
        }
    }
}

