/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;

@OpMetadata(opType="SendTPUEmbeddingGradients", inputsClass=Inputs.class)
public final class SendTPUEmbeddingGradients
extends RawOp {
    public static final String OP_NAME = "SendTPUEmbeddingGradients";

    public SendTPUEmbeddingGradients(Operation operation) {
        super(operation, OP_NAME);
    }

    public static SendTPUEmbeddingGradients create(Scope scope, Iterable<Operand<TFloat32>> inputs, Iterable<Operand<TFloat32>> learningRates, String config, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(inputs));
        opBuilder.addInputList(Operands.asOutputs(learningRates));
        opBuilder.setAttr("config", config);
        if (options != null) {
            for (Options opts : options) {
                if (opts.NN == null) continue;
                opBuilder.setAttr("NN", opts.NN);
            }
        }
        return new SendTPUEmbeddingGradients(opBuilder.build());
    }

    public static Options NN(Long NN) {
        return new Options().NN(NN);
    }

    @OpInputsMetadata(outputsClass=SendTPUEmbeddingGradients.class)
    public static class Inputs
    extends RawOpInputs<SendTPUEmbeddingGradients> {
        public final Iterable<Operand<TFloat32>> inputs;
        public final Iterable<Operand<TFloat32>> learningRates;
        public final String config;

        public Inputs(GraphOperation op) {
            super(new SendTPUEmbeddingGradients(op), op, Arrays.asList("config"));
            int inputIndex = 0;
            int inputsLength = op.inputListLength("inputs");
            this.inputs = Arrays.asList((Operand[])op.inputList(inputIndex, inputsLength));
            int learningRatesLength = op.inputListLength("learning_rates");
            this.learningRates = Arrays.asList((Operand[])op.inputList(inputIndex += inputsLength, learningRatesLength));
            inputIndex += learningRatesLength;
            this.config = op.attributes().getAttrString("config");
        }
    }

    public static class Options {
        private Long NN;

        private Options() {
        }

        public Options NN(Long NN) {
            this.NN = NN;
            return this;
        }
    }
}

