/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.estimator;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="BoostedTreesCreateQuantileStreamResource", inputsClass=Inputs.class)
public final class BoostedTreesCreateQuantileStreamResource
extends RawOp {
    public static final String OP_NAME = "BoostedTreesCreateQuantileStreamResource";

    public BoostedTreesCreateQuantileStreamResource(Operation operation) {
        super(operation, OP_NAME);
    }

    public static BoostedTreesCreateQuantileStreamResource create(Scope scope, Operand<? extends TType> quantileStreamResourceHandle, Operand<TFloat32> epsilon, Operand<TInt64> numStreams, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(quantileStreamResourceHandle.asOutput());
        opBuilder.addInput(epsilon.asOutput());
        opBuilder.addInput(numStreams.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.maxElements == null) continue;
                opBuilder.setAttr("max_elements", opts.maxElements);
            }
        }
        return new BoostedTreesCreateQuantileStreamResource(opBuilder.build());
    }

    public static Options maxElements(Long maxElements) {
        return new Options().maxElements(maxElements);
    }

    @OpInputsMetadata(outputsClass=BoostedTreesCreateQuantileStreamResource.class)
    public static class Inputs
    extends RawOpInputs<BoostedTreesCreateQuantileStreamResource> {
        public final Operand<? extends TType> quantileStreamResourceHandle;
        public final Operand<TFloat32> epsilon;
        public final Operand<TInt64> numStreams;
        public final long maxElements;

        public Inputs(GraphOperation op) {
            super(new BoostedTreesCreateQuantileStreamResource(op), op, Arrays.asList("max_elements"));
            int inputIndex = 0;
            this.quantileStreamResourceHandle = op.input(inputIndex++);
            this.epsilon = op.input(inputIndex++);
            this.numStreams = op.input(inputIndex++);
            this.maxElements = op.attributes().getAttrInt("max_elements");
        }
    }

    public static class Options {
        private Long maxElements;

        private Options() {
        }

        public Options maxElements(Long maxElements) {
            this.maxElements = maxElements;
            return this;
        }
    }
}

