/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ParallelConcat", inputsClass=Inputs.class)
public final class ParallelConcat<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "ParallelConcat";
    private Output<T> output;

    public ParallelConcat(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> ParallelConcat<T> create(Scope scope, Iterable<Operand<T>> values, Shape shape) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(values));
        opBuilder.setAttr("shape", shape);
        return new ParallelConcat<T>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=ParallelConcat.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<ParallelConcat<T>> {
        public final Iterable<Operand<T>> values;
        public final DataType T;
        public final Shape shape;

        public Inputs(GraphOperation op) {
            super(new ParallelConcat(op), op, Arrays.asList("T", "shape"));
            int inputIndex = 0;
            int valuesLength = op.inputListLength("values");
            this.values = Arrays.asList((Operand[])op.inputList(inputIndex, valuesLength));
            inputIndex += valuesLength;
            this.T = op.attributes().getAttrType("T");
            this.shape = op.attributes().getAttrShape("shape");
        }
    }
}

