/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.op.core.PartitionedCall;
import org.tensorflow.proto.framework.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="PartitionedCall", inputsClass=Inputs.class)
public final class StatelessPartitionedCall
extends RawOp
implements PartitionedCall {
    public static final String OP_NAME = "PartitionedCall";
    private List<Output<?>> output;

    public StatelessPartitionedCall(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputLength = operation.outputListLength("output");
        this.output = Arrays.asList(operation.outputList(outputIdx, outputLength));
        outputIdx += outputLength;
    }

    public static StatelessPartitionedCall create(Scope scope, Iterable<Operand<?>> args, List<Class<? extends TType>> Tout, ConcreteFunction f, PartitionedCall.Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "StatelessPartitionedCall");
        opBuilder.addInputList(Operands.asOutputs(args));
        opBuilder.setAttr("Tout", Operands.toDataTypes(Tout));
        opBuilder.setAttr("f", f);
        if (options != null) {
            for (PartitionedCall.Options opts : options) {
                if (opts.config != null) {
                    opBuilder.setAttr("config", opts.config);
                }
                if (opts.configProto != null) {
                    opBuilder.setAttr("config_proto", opts.configProto);
                }
                if (opts.executorType == null) continue;
                opBuilder.setAttr("executor_type", opts.executorType);
            }
        }
        return new StatelessPartitionedCall(opBuilder.build());
    }

    @Override
    public List<Output<?>> output() {
        return this.output;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.output.iterator();
    }

    @OpInputsMetadata(outputsClass=StatelessPartitionedCall.class)
    public static class Inputs
    extends RawOpInputs<StatelessPartitionedCall> {
        public final Iterable<Operand<?>> args;
        public final DataType[] Tin;
        public final DataType[] Tout;
        public final String config;
        public final String configProto;
        public final String executorType;

        public Inputs(GraphOperation op) {
            super(new StatelessPartitionedCall(op), op, Arrays.asList("Tin", "Tout", "config", "config_proto", "executor_type"));
            int inputIndex = 0;
            int argsLength = op.inputListLength("args");
            this.args = Arrays.asList((Operand[])op.inputList(inputIndex, argsLength));
            inputIndex += argsLength;
            this.Tin = op.attributes().getAttrTypeList("Tin");
            this.Tout = op.attributes().getAttrTypeList("Tout");
            this.config = op.attributes().getAttrString("config");
            this.configProto = op.attributes().getAttrString("config_proto");
            this.executorType = op.attributes().getAttrString("executor_type");
        }
    }
}

