/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.Operand;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Scope;
import org.tensorflow.op.core.StatefulCase;
import org.tensorflow.op.core.StatelessCase;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

public interface Case
extends Iterable<Operand<TType>> {
    public static Case create(Scope scope, Operand<TInt32> branchIndex, Iterable<Operand<?>> input, List<Class<? extends TType>> Tout, List<ConcreteFunction> branches, Options ... options) {
        boolean isStateful = false;
        if (branches.stream().anyMatch(x -> x.isStateful())) {
            isStateful = true;
        }
        if (isStateful) {
            return StatefulCase.create(scope, branchIndex, input, Tout, branches, options);
        }
        return StatelessCase.create(scope, branchIndex, input, Tout, branches, options);
    }

    public static Options outputShapes(List<Shape> outputShapes) {
        return new Options().outputShapes(outputShapes);
    }

    public static Options outputShapes(Shape ... outputShapes) {
        return new Options().outputShapes(outputShapes);
    }

    public List<Output<?>> output();

    @Override
    public Iterator<Operand<TType>> iterator();

    public static class Options {
        List<Shape> outputShapes;

        private Options() {
        }

        public Options outputShapes(List<Shape> outputShapes) {
            this.outputShapes = outputShapes;
            return this;
        }

        public Options outputShapes(Shape ... outputShapes) {
            this.outputShapes = Arrays.asList(outputShapes);
            return this;
        }
    }
}

