/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

public final class TopK<T extends TNumber>
extends RawOp {
    public static final String OP_NAME = "TopKV2";
    private Output<T> values;
    private Output<TInt32> indices;

    public static <T extends TNumber> TopK<T> create(Scope scope, Operand<T> input, Operand<TInt32> k, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("TopK"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(k.asOutput());
        opBuilder = scope.apply(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.sorted == null) continue;
                opBuilder.setAttr("sorted", opts.sorted);
            }
        }
        return new TopK<T>(opBuilder.build());
    }

    public static Options sorted(Boolean sorted) {
        return new Options().sorted(sorted);
    }

    public Output<T> values() {
        return this.values;
    }

    public Output<TInt32> indices() {
        return this.indices;
    }

    private TopK(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.values = operation.output(outputIdx++);
        this.indices = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean sorted;

        public Options sorted(Boolean sorted) {
            this.sorted = sorted;
            return this;
        }

        private Options() {
        }
    }
}

