/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data.experimental;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

public final class AutoShardDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "ExperimentalAutoShardDataset";
    private Output<?> handle;

    public static AutoShardDataset create(Scope scope, Operand<?> inputDataset, Operand<TInt64> numWorkers, Operand<TInt64> index, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("AutoShardDataset"));
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(numWorkers.asOutput());
        opBuilder.addInput(index.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.autoShardPolicy == null) continue;
                opBuilder.setAttr("auto_shard_policy", opts.autoShardPolicy);
            }
        }
        return new AutoShardDataset(opBuilder.build());
    }

    public static Options autoShardPolicy(Long autoShardPolicy) {
        return new Options().autoShardPolicy(autoShardPolicy);
    }

    public Output<?> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    private AutoShardDataset(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static class Options {
        private Long autoShardPolicy;

        public Options autoShardPolicy(Long autoShardPolicy) {
            this.autoShardPolicy = autoShardPolicy;
            return this;
        }

        private Options() {
        }
    }
}

