/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class TPUReplicatedInput<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "TPUReplicatedInput";
    private Output<T> output;

    public static <T extends TType> TPUReplicatedInput<T> create(Scope scope, Iterable<Operand<T>> inputs, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInputList(Operands.asOutputs(inputs));
        opBuilder = scope.apply(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.isMirroredVariable != null) {
                    opBuilder.setAttr("is_mirrored_variable", opts.isMirroredVariable);
                }
                if (opts.index != null) {
                    opBuilder.setAttr("index", opts.index);
                }
                if (opts.isPacked == null) continue;
                opBuilder.setAttr("is_packed", opts.isPacked);
            }
        }
        return new TPUReplicatedInput<T>(opBuilder.build());
    }

    public static Options isMirroredVariable(Boolean isMirroredVariable) {
        return new Options().isMirroredVariable(isMirroredVariable);
    }

    public static Options index(Long index) {
        return new Options().index(index);
    }

    public static Options isPacked(Boolean isPacked) {
        return new Options().isPacked(isPacked);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private TPUReplicatedInput(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean isMirroredVariable;
        private Long index;
        private Boolean isPacked;

        public Options isMirroredVariable(Boolean isMirroredVariable) {
            this.isMirroredVariable = isMirroredVariable;
            return this;
        }

        public Options index(Long index) {
            this.index = index;
            return this;
        }

        public Options isPacked(Boolean isPacked) {
            this.isPacked = isPacked;
            return this;
        }

        private Options() {
        }
    }
}

