/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import org.tensorflow.Operand;
import org.tensorflow.op.Ops;
import org.tensorflow.op.Scope;
import org.tensorflow.op.linalg.BandPart;
import org.tensorflow.op.linalg.BatchCholesky;
import org.tensorflow.op.linalg.BatchCholeskyGrad;
import org.tensorflow.op.linalg.BatchMatrixBandPart;
import org.tensorflow.op.linalg.BatchMatrixDeterminant;
import org.tensorflow.op.linalg.BatchMatrixDiag;
import org.tensorflow.op.linalg.BatchMatrixDiagPart;
import org.tensorflow.op.linalg.BatchMatrixInverse;
import org.tensorflow.op.linalg.BatchMatrixSetDiag;
import org.tensorflow.op.linalg.BatchMatrixSolve;
import org.tensorflow.op.linalg.BatchMatrixSolveLs;
import org.tensorflow.op.linalg.BatchMatrixTriangularSolve;
import org.tensorflow.op.linalg.BatchSelfAdjointEig;
import org.tensorflow.op.linalg.BatchSvd;
import org.tensorflow.op.linalg.Cholesky;
import org.tensorflow.op.linalg.CholeskyGrad;
import org.tensorflow.op.linalg.ConjugateTranspose;
import org.tensorflow.op.linalg.Cross;
import org.tensorflow.op.linalg.Det;
import org.tensorflow.op.linalg.Eig;
import org.tensorflow.op.linalg.Einsum;
import org.tensorflow.op.linalg.EuclideanNorm;
import org.tensorflow.op.linalg.Inv;
import org.tensorflow.op.linalg.LoadAndRemapMatrix;
import org.tensorflow.op.linalg.LogMatrixDeterminant;
import org.tensorflow.op.linalg.Lu;
import org.tensorflow.op.linalg.MatMul;
import org.tensorflow.op.linalg.MatrixDiag;
import org.tensorflow.op.linalg.MatrixDiagPart;
import org.tensorflow.op.linalg.MatrixDiagPartV3;
import org.tensorflow.op.linalg.MatrixDiagV3;
import org.tensorflow.op.linalg.MatrixSetDiag;
import org.tensorflow.op.linalg.MatrixSolveLs;
import org.tensorflow.op.linalg.Qr;
import org.tensorflow.op.linalg.QuantizedMatMul;
import org.tensorflow.op.linalg.SelfAdjointEig;
import org.tensorflow.op.linalg.Solve;
import org.tensorflow.op.linalg.Sqrtm;
import org.tensorflow.op.linalg.Svd;
import org.tensorflow.op.linalg.TensorDiag;
import org.tensorflow.op.linalg.TensorDiagPart;
import org.tensorflow.op.linalg.Transpose;
import org.tensorflow.op.linalg.TriangularSolve;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TFloat64;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class LinalgOps {
    private final Scope scope;
    private final Ops ops;

    LinalgOps(Ops ops) {
        this.scope = ops.scope();
        this.ops = ops;
    }

    public <T extends TType, U extends TNumber> BandPart<T> bandPart(Operand<T> input, Operand<U> numLower, Operand<U> numUpper) {
        return BandPart.create(this.scope, input, numLower, numUpper);
    }

    public <T extends TNumber> BatchCholesky<T> batchCholesky(Operand<T> input) {
        return BatchCholesky.create(this.scope, input);
    }

    public <T extends TNumber> BatchCholeskyGrad<T> batchCholeskyGrad(Operand<T> l, Operand<T> grad) {
        return BatchCholeskyGrad.create(this.scope, l, grad);
    }

    public <T extends TType> BatchMatrixBandPart<T> batchMatrixBandPart(Operand<T> input, Operand<TInt64> numLower, Operand<TInt64> numUpper) {
        return BatchMatrixBandPart.create(this.scope, input, numLower, numUpper);
    }

    public <T extends TType> BatchMatrixDeterminant<T> batchMatrixDeterminant(Operand<T> input) {
        return BatchMatrixDeterminant.create(this.scope, input);
    }

    public <T extends TType> BatchMatrixDiag<T> batchMatrixDiag(Operand<T> diagonal) {
        return BatchMatrixDiag.create(this.scope, diagonal);
    }

    public <T extends TType> BatchMatrixDiagPart<T> batchMatrixDiagPart(Operand<T> input) {
        return BatchMatrixDiagPart.create(this.scope, input);
    }

    public <T extends TNumber> BatchMatrixInverse<T> batchMatrixInverse(Operand<T> input, BatchMatrixInverse.Options ... options) {
        return BatchMatrixInverse.create(this.scope, input, options);
    }

    public <T extends TType> BatchMatrixSetDiag<T> batchMatrixSetDiag(Operand<T> input, Operand<T> diagonal) {
        return BatchMatrixSetDiag.create(this.scope, input, diagonal);
    }

    public <T extends TNumber> BatchMatrixSolve<T> batchMatrixSolve(Operand<T> matrix, Operand<T> rhs, BatchMatrixSolve.Options ... options) {
        return BatchMatrixSolve.create(this.scope, matrix, rhs, options);
    }

    public <T extends TNumber> BatchMatrixSolveLs<T> batchMatrixSolveLs(Operand<T> matrix, Operand<T> rhs, Operand<TFloat64> l2Regularizer, BatchMatrixSolveLs.Options ... options) {
        return BatchMatrixSolveLs.create(this.scope, matrix, rhs, l2Regularizer, options);
    }

    public <T extends TNumber> BatchMatrixTriangularSolve<T> batchMatrixTriangularSolve(Operand<T> matrix, Operand<T> rhs, BatchMatrixTriangularSolve.Options ... options) {
        return BatchMatrixTriangularSolve.create(this.scope, matrix, rhs, options);
    }

    public <T extends TNumber> BatchSelfAdjointEig<T> batchSelfAdjointEig(Operand<T> input, BatchSelfAdjointEig.Options ... options) {
        return BatchSelfAdjointEig.create(this.scope, input, options);
    }

    public <T extends TType> BatchSvd<T> batchSvd(Operand<T> input, BatchSvd.Options ... options) {
        return BatchSvd.create(this.scope, input, options);
    }

    public <T extends TType> Cholesky<T> cholesky(Operand<T> input) {
        return Cholesky.create(this.scope, input);
    }

    public <T extends TNumber> CholeskyGrad<T> choleskyGrad(Operand<T> l, Operand<T> grad) {
        return CholeskyGrad.create(this.scope, l, grad);
    }

    public <T extends TType> ConjugateTranspose<T> conjugateTranspose(Operand<T> x, Operand<? extends TNumber> perm) {
        return ConjugateTranspose.create(this.scope, x, perm);
    }

    public <T extends TNumber> Cross<T> cross(Operand<T> a, Operand<T> b) {
        return Cross.create(this.scope, a, b);
    }

    public <T extends TType> Det<T> det(Operand<T> input) {
        return Det.create(this.scope, input);
    }

    public <U extends TType> Eig<U> eig(Operand<? extends TType> input, Class<U> Tout, Eig.Options ... options) {
        return Eig.create(this.scope, input, Tout, options);
    }

    public <T extends TType> Einsum<T> einsum(Iterable<Operand<T>> inputs, String equation) {
        return Einsum.create(this.scope, inputs, equation);
    }

    public <T extends TType> EuclideanNorm<T> euclideanNorm(Operand<T> input, Operand<? extends TNumber> axis, EuclideanNorm.Options ... options) {
        return EuclideanNorm.create(this.scope, input, axis, options);
    }

    public <T extends TType> Inv<T> inv(Operand<T> input, Inv.Options ... options) {
        return Inv.create(this.scope, input, options);
    }

    public LoadAndRemapMatrix loadAndRemapMatrix(Operand<TString> ckptPath, Operand<TString> oldTensorName, Operand<TInt64> rowRemapping, Operand<TInt64> colRemapping, Operand<TFloat32> initializingValues, Long numRows, Long numCols, LoadAndRemapMatrix.Options ... options) {
        return LoadAndRemapMatrix.create(this.scope, ckptPath, oldTensorName, rowRemapping, colRemapping, initializingValues, numRows, numCols, options);
    }

    public <T extends TType> LogMatrixDeterminant<T> logMatrixDeterminant(Operand<T> input) {
        return LogMatrixDeterminant.create(this.scope, input);
    }

    public <T extends TType> Lu<T, TInt32> lu(Operand<T> input) {
        return Lu.create(this.scope, input);
    }

    public <T extends TType, U extends TNumber> Lu<T, U> lu(Operand<T> input, Class<U> outputIdxType) {
        return Lu.create(this.scope, input, outputIdxType);
    }

    public <T extends TType> MatMul<T> matMul(Operand<T> a, Operand<T> b, MatMul.Options ... options) {
        return MatMul.create(this.scope, a, b, options);
    }

    public <T extends TType> MatrixDiag<T> matrixDiag(Operand<T> diagonal, Operand<TInt32> k, Operand<TInt32> numRows, Operand<TInt32> numCols, Operand<T> paddingValue) {
        return MatrixDiag.create(this.scope, diagonal, k, numRows, numCols, paddingValue);
    }

    public <T extends TType> MatrixDiagPart<T> matrixDiagPart(Operand<T> input, Operand<TInt32> k, Operand<T> paddingValue) {
        return MatrixDiagPart.create(this.scope, input, k, paddingValue);
    }

    public <T extends TType> MatrixDiagPartV3<T> matrixDiagPartV3(Operand<T> input, Operand<TInt32> k, Operand<T> paddingValue, MatrixDiagPartV3.Options ... options) {
        return MatrixDiagPartV3.create(this.scope, input, k, paddingValue, options);
    }

    public <T extends TType> MatrixDiagV3<T> matrixDiagV3(Operand<T> diagonal, Operand<TInt32> k, Operand<TInt32> numRows, Operand<TInt32> numCols, Operand<T> paddingValue, MatrixDiagV3.Options ... options) {
        return MatrixDiagV3.create(this.scope, diagonal, k, numRows, numCols, paddingValue, options);
    }

    public <T extends TType> MatrixSetDiag<T> matrixSetDiag(Operand<T> input, Operand<T> diagonal, Operand<TInt32> k, MatrixSetDiag.Options ... options) {
        return MatrixSetDiag.create(this.scope, input, diagonal, k, options);
    }

    public <T extends TType> MatrixSolveLs<T> matrixSolveLs(Operand<T> matrix, Operand<T> rhs, Operand<TFloat64> l2Regularizer, MatrixSolveLs.Options ... options) {
        return MatrixSolveLs.create(this.scope, matrix, rhs, l2Regularizer, options);
    }

    public <T extends TType> Qr<T> qr(Operand<T> input, Qr.Options ... options) {
        return Qr.create(this.scope, input, options);
    }

    public <V extends TType, W extends TType> QuantizedMatMul<V> quantizedMatMul(Operand<? extends TType> a, Operand<? extends TType> b, Operand<TFloat32> minA, Operand<TFloat32> maxA, Operand<TFloat32> minB, Operand<TFloat32> maxB, Class<V> Toutput, Class<W> Tactivation, QuantizedMatMul.Options ... options) {
        return QuantizedMatMul.create(this.scope, a, b, minA, maxA, minB, maxB, Toutput, Tactivation, options);
    }

    public <T extends TType> SelfAdjointEig<T> selfAdjointEig(Operand<T> input, SelfAdjointEig.Options ... options) {
        return SelfAdjointEig.create(this.scope, input, options);
    }

    public <T extends TType> Solve<T> solve(Operand<T> matrix, Operand<T> rhs, Solve.Options ... options) {
        return Solve.create(this.scope, matrix, rhs, options);
    }

    public <T extends TType> Sqrtm<T> sqrtm(Operand<T> input) {
        return Sqrtm.create(this.scope, input);
    }

    public <T extends TType> Svd<T> svd(Operand<T> input, Svd.Options ... options) {
        return Svd.create(this.scope, input, options);
    }

    public <T extends TType> TensorDiag<T> tensorDiag(Operand<T> diagonal) {
        return TensorDiag.create(this.scope, diagonal);
    }

    public <T extends TType> TensorDiagPart<T> tensorDiagPart(Operand<T> input) {
        return TensorDiagPart.create(this.scope, input);
    }

    public <T extends TType> Transpose<T> transpose(Operand<T> x, Operand<? extends TNumber> perm) {
        return Transpose.create(this.scope, x, perm);
    }

    public <T extends TType> TriangularSolve<T> triangularSolve(Operand<T> matrix, Operand<T> rhs, TriangularSolve.Options ... options) {
        return TriangularSolve.create(this.scope, matrix, rhs, options);
    }

    public final Ops ops() {
        return this.ops;
    }
}

