/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.dense;

import org.tensorflow.ndarray.BooleanNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.buffer.BooleanDataBuffer;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.impl.dense.AbstractDenseNdArray;
import org.tensorflow.ndarray.impl.dense.DataTransfer;
import org.tensorflow.ndarray.impl.dense.Validator;
import org.tensorflow.ndarray.impl.dimension.DimensionalSpace;

public class BooleanDenseNdArray
extends AbstractDenseNdArray<Boolean, BooleanNdArray>
implements BooleanNdArray {
    private final BooleanDataBuffer buffer;

    public static BooleanNdArray create(BooleanDataBuffer buffer, Shape shape) {
        Validator.denseShape(buffer, shape);
        return new BooleanDenseNdArray(buffer, shape);
    }

    @Override
    public boolean getBoolean(long ... indices) {
        return this.buffer.getBoolean(this.positionOf(indices, true));
    }

    @Override
    public BooleanNdArray setBoolean(boolean value, long ... indices) {
        this.buffer.setBoolean(value, this.positionOf(indices, true));
        return this;
    }

    @Override
    public BooleanNdArray copyTo(NdArray<Boolean> dst) {
        Validator.copyToNdArrayArgs(this, dst);
        if (dst instanceof BooleanDenseNdArray) {
            BooleanDenseNdArray booleanDst = (BooleanDenseNdArray)dst;
            DataTransfer.execute(this.buffer, this.dimensions(), booleanDst.buffer, booleanDst.dimensions(), DataTransfer::ofBoolean);
        } else {
            this.slowCopyTo(dst);
        }
        return this;
    }

    @Override
    public BooleanNdArray read(BooleanDataBuffer dst) {
        Validator.readToBufferArgs(this, dst);
        DataTransfer.execute(this.buffer, this.dimensions(), dst, DataTransfer::ofBoolean);
        return this;
    }

    @Override
    public BooleanNdArray write(BooleanDataBuffer src) {
        Validator.writeFromBufferArgs(this, src);
        DataTransfer.execute(src, this.buffer, this.dimensions(), DataTransfer::ofBoolean);
        return this;
    }

    protected BooleanDenseNdArray(BooleanDataBuffer buffer, Shape shape) {
        this(buffer, DimensionalSpace.create(shape));
    }

    @Override
    BooleanDenseNdArray instantiate(DataBuffer<Boolean> buffer, DimensionalSpace dimensions) {
        return new BooleanDenseNdArray((BooleanDataBuffer)buffer, dimensions);
    }

    protected BooleanDataBuffer buffer() {
        return this.buffer;
    }

    private BooleanDenseNdArray(BooleanDataBuffer buffer, DimensionalSpace dimensions) {
        super(dimensions);
        this.buffer = buffer;
    }
}

