/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.impl.buffer;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.tensorflow.ndarray.buffer.DataBuffer;
import org.tensorflow.ndarray.impl.buffer.Validator;

public abstract class AbstractDataBuffer<T>
implements DataBuffer<T> {
    private static final Map<Class<?>, ArrayHashCoder> ARRAY_HASH_CODERS = new HashMap();
    private static final ArrayHashCoder DEFAULT_ARRAY_HASH_CODER;
    private static final Map<Class<?>, ArrayComparator> ARRAY_COMPARATORS;
    private static final ArrayComparator DEFAULT_ARRAY_COMPARATOR;

    @Override
    public DataBuffer<T> read(T[] dst, int offset, int length) {
        Validator.readArgs(this, dst.length, offset, length);
        for (int i = 0; i < length; ++i) {
            dst[i + offset] = this.getObject(i);
        }
        return this;
    }

    @Override
    public DataBuffer<T> write(T[] src, int offset, int length) {
        Validator.writeArgs(this, src.length, offset, length);
        for (int i = 0; i < length; ++i) {
            this.setObject(src[i + offset], i);
        }
        return this;
    }

    @Override
    public DataBuffer<T> copyTo(DataBuffer<T> dst, long size) {
        return this.slowCopyTo(dst, size);
    }

    public int hashCode() {
        return this.slowHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataBuffer)) {
            return false;
        }
        return this.slowEquals((DataBuffer)obj);
    }

    protected <U extends DataBuffer<T>> U slowCopyTo(DataBuffer<T> dst, long size) {
        Validator.copyToArgs(this, dst, size);
        for (long idx = 0L; idx < size; ++idx) {
            dst.setObject(this.getObject(idx), idx);
        }
        return (U)this;
    }

    protected int slowHashCode() {
        long idx;
        int prime = 31;
        int result = 1;
        for (idx = 0L; idx < this.size(); ++idx) {
            Object o = this.getObject(idx);
            if (o != null) {
                if (o.getClass().isArray()) {
                    result = 31 * result + this.arrayHashCode(idx, o.getClass());
                    return result;
                }
                result = 31 * result + o.hashCode();
                break;
            }
            result = 31 * result;
        }
        while (++idx < this.size()) {
            result = 31 * result + Objects.hashCode(this.getObject(idx));
        }
        return result;
    }

    protected boolean slowEquals(DataBuffer<?> other) {
        long idx;
        if (other.size() != this.size()) {
            return false;
        }
        for (idx = 0L; idx < this.size(); ++idx) {
            Object thisObject = this.getObject(idx);
            if (thisObject != null) {
                if (thisObject.getClass().isArray()) {
                    return this.arrayEquals(idx, thisObject.getClass(), other);
                }
                if (Objects.equals(other.getObject(idx), thisObject)) break;
                return false;
            }
            if (other.getObject(idx) == null) continue;
            return false;
        }
        while (++idx < this.size()) {
            if (Objects.equals(other.getObject(idx), this.getObject(idx))) continue;
            return false;
        }
        return true;
    }

    private int arrayHashCode(long startIdx, Class<?> arrayClass) {
        ArrayHashCoder hashCoder = ARRAY_HASH_CODERS.getOrDefault(arrayClass, DEFAULT_ARRAY_HASH_CODER);
        int prime = 31;
        int result = 1;
        for (long idx = startIdx; idx < this.size(); ++idx) {
            result = 31 * result + hashCoder.hashCode(this, idx);
        }
        return result;
    }

    private boolean arrayEquals(long startIdx, Class<?> arrayClass, DataBuffer<?> other) {
        ArrayComparator comparator = ARRAY_COMPARATORS.getOrDefault(arrayClass, DEFAULT_ARRAY_COMPARATOR);
        for (long idx = startIdx; idx < this.size(); ++idx) {
            if (comparator.equals(this, other, idx)) continue;
            return false;
        }
        return true;
    }

    static {
        ARRAY_COMPARATORS = new HashMap();
        ARRAY_HASH_CODERS.put(byte[].class, (b, idx) -> Arrays.hashCode((byte[])b.getObject(idx)));
        ARRAY_HASH_CODERS.put(int[].class, (b, idx) -> Arrays.hashCode((int[])b.getObject(idx)));
        ARRAY_HASH_CODERS.put(short[].class, (b, idx) -> Arrays.hashCode((short[])b.getObject(idx)));
        ARRAY_HASH_CODERS.put(long[].class, (b, idx) -> Arrays.hashCode((long[])b.getObject(idx)));
        ARRAY_HASH_CODERS.put(float[].class, (b, idx) -> Arrays.hashCode((float[])b.getObject(idx)));
        ARRAY_HASH_CODERS.put(double[].class, (b, idx) -> Arrays.hashCode((double[])b.getObject(idx)));
        ARRAY_HASH_CODERS.put(boolean[].class, (b, idx) -> Arrays.hashCode((boolean[])b.getObject(idx)));
        DEFAULT_ARRAY_HASH_CODER = (b, idx) -> Arrays.deepHashCode((Object[])b.getObject(idx));
        ARRAY_COMPARATORS.put(byte[].class, (b1, b2, idx) -> Arrays.equals((byte[])b1.getObject(idx), (byte[])b2.getObject(idx)));
        ARRAY_COMPARATORS.put(int[].class, (b1, b2, idx) -> Arrays.equals((int[])b1.getObject(idx), (int[])b2.getObject(idx)));
        ARRAY_COMPARATORS.put(short[].class, (b1, b2, idx) -> Arrays.equals((short[])b1.getObject(idx), (short[])b2.getObject(idx)));
        ARRAY_COMPARATORS.put(long[].class, (b1, b2, idx) -> Arrays.equals((long[])b1.getObject(idx), (long[])b2.getObject(idx)));
        ARRAY_COMPARATORS.put(float[].class, (b1, b2, idx) -> Arrays.equals((float[])b1.getObject(idx), (float[])b2.getObject(idx)));
        ARRAY_COMPARATORS.put(double[].class, (b1, b2, idx) -> Arrays.equals((double[])b1.getObject(idx), (double[])b2.getObject(idx)));
        ARRAY_COMPARATORS.put(boolean[].class, (b1, b2, idx) -> Arrays.equals((boolean[])b1.getObject(idx), (boolean[])b2.getObject(idx)));
        DEFAULT_ARRAY_COMPARATOR = (b1, b2, idx) -> Arrays.deepEquals((Object[])b1.getObject(idx), (Object[])b2.getObject(idx));
    }

    @FunctionalInterface
    private static interface ArrayComparator {
        public boolean equals(DataBuffer<?> var1, DataBuffer<?> var2, long var3);
    }

    @FunctionalInterface
    private static interface ArrayHashCoder {
        public int hashCode(DataBuffer<?> var1, long var2);
    }
}

