/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import org.tensorflow.Operand;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Scope;
import org.tensorflow.op.core.Select;
import org.tensorflow.op.core.ZerosLike;
import org.tensorflow.op.dtypes.Cast;
import org.tensorflow.op.math.Add;
import org.tensorflow.op.math.Exp;
import org.tensorflow.op.math.GreaterEqual;
import org.tensorflow.op.math.Log1p;
import org.tensorflow.op.math.Mul;
import org.tensorflow.op.math.Neg;
import org.tensorflow.op.math.Sub;
import org.tensorflow.types.family.TNumber;

public class SigmoidCrossEntropyWithLogits {
    public static <T extends TNumber> Operand<T> sigmoidCrossEntropyWithLogits(Scope scope, Operand<T> labels, Operand<T> logits) {
        if (!SigmoidCrossEntropyWithLogits.isCompatible(labels.shape(), logits.shape())) {
            throw new IllegalArgumentException(String.format("logits and labels must have the same shape (%s vs %s)", labels.shape(), logits.shape()));
        }
        scope = scope.withSubScope("SigmoidCrossEntropyWithLogits");
        Cast<T> zeros = Cast.create(scope, ZerosLike.create(scope, logits), logits.asOutput().type(), new Cast.Options[0]);
        GreaterEqual cond = GreaterEqual.create(scope, logits, zeros);
        Select<T> reluLogits = Select.create(scope, cond, logits, zeros);
        Select<T> negAbsLogits = Select.create(scope, cond, Neg.create(scope, logits), logits);
        return Add.create(scope, Sub.create(scope, reluLogits, Mul.create(scope, logits, labels)), Log1p.create(scope, Exp.create(scope, negAbsLogits)));
    }

    private static boolean isCompatible(Shape shape, Shape other) {
        if (shape.numDimensions() != other.numDimensions()) {
            return false;
        }
        for (int i = 0; i < shape.numDimensions(); ++i) {
            long bShapeDim;
            long aShapeDim = shape.size(i);
            if (aShapeDim == (bShapeDim = other.size(i)) || aShapeDim == Shape.UNKNOWN_SIZE || bShapeDim == Shape.UNKNOWN_SIZE) continue;
            return false;
        }
        return true;
    }
}

