/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

public final class Bucketize
extends RawOp
implements Operand<TInt32> {
    public static final String OP_NAME = "Bucketize";
    private Output<TInt32> output;

    public static Bucketize create(Scope scope, Operand<? extends TNumber> input, List<Float> boundaries) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(input.asOutput());
        opBuilder = scope.apply(opBuilder);
        float[] boundariesArray = new float[boundaries.size()];
        for (int i = 0; i < boundariesArray.length; ++i) {
            boundariesArray[i] = boundaries.get(i).floatValue();
        }
        opBuilder.setAttr("boundaries", boundariesArray);
        return new Bucketize(opBuilder.build());
    }

    public Output<TInt32> output() {
        return this.output;
    }

    @Override
    public Output<TInt32> asOutput() {
        return this.output;
    }

    private Bucketize(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }
}

