/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.quantization;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;

public final class FakeQuantWithMinMaxVarsPerChannelGradient
extends RawOp {
    public static final String OP_NAME = "FakeQuantWithMinMaxVarsPerChannelGradient";
    private Output<TFloat32> backpropsWrtInput;
    private Output<TFloat32> backpropWrtMin;
    private Output<TFloat32> backpropWrtMax;

    public static FakeQuantWithMinMaxVarsPerChannelGradient create(Scope scope, Operand<TFloat32> gradients, Operand<TFloat32> inputs, Operand<TFloat32> min, Operand<TFloat32> max, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(gradients.asOutput());
        opBuilder.addInput(inputs.asOutput());
        opBuilder.addInput(min.asOutput());
        opBuilder.addInput(max.asOutput());
        opBuilder = scope.apply(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.numBits != null) {
                    opBuilder.setAttr("num_bits", opts.numBits);
                }
                if (opts.narrowRange == null) continue;
                opBuilder.setAttr("narrow_range", opts.narrowRange);
            }
        }
        return new FakeQuantWithMinMaxVarsPerChannelGradient(opBuilder.build());
    }

    public static Options numBits(Long numBits) {
        return new Options().numBits(numBits);
    }

    public static Options narrowRange(Boolean narrowRange) {
        return new Options().narrowRange(narrowRange);
    }

    public Output<TFloat32> backpropsWrtInput() {
        return this.backpropsWrtInput;
    }

    public Output<TFloat32> backpropWrtMin() {
        return this.backpropWrtMin;
    }

    public Output<TFloat32> backpropWrtMax() {
        return this.backpropWrtMax;
    }

    private FakeQuantWithMinMaxVarsPerChannelGradient(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.backpropsWrtInput = operation.output(outputIdx++);
        this.backpropWrtMin = operation.output(outputIdx++);
        this.backpropWrtMax = operation.output(outputIdx++);
    }

    public static class Options {
        private Long numBits;
        private Boolean narrowRange;

        public Options numBits(Long numBits) {
            this.numBits = numBits;
            return this;
        }

        public Options narrowRange(Boolean narrowRange) {
            this.narrowRange = narrowRange;
            return this;
        }

        private Options() {
        }
    }
}

