/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

public final class CropAndResizeGradImage<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "CropAndResizeGradImage";
    private Output<T> output;

    public static <T extends TNumber> CropAndResizeGradImage<T> create(Scope scope, Operand<TFloat32> grads, Operand<TFloat32> boxes, Operand<TInt32> boxInd, Operand<TInt32> imageSize, Class<T> T, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder.addInput(grads.asOutput());
        opBuilder.addInput(boxes.asOutput());
        opBuilder.addInput(boxInd.asOutput());
        opBuilder.addInput(imageSize.asOutput());
        opBuilder = scope.apply(opBuilder);
        opBuilder.setAttr("T", Operands.toDataType(T));
        if (options != null) {
            for (Options opts : options) {
                if (opts.method == null) continue;
                opBuilder.setAttr("method", opts.method);
            }
        }
        return new CropAndResizeGradImage<T>(opBuilder.build());
    }

    public static Options method(String method) {
        return new Options().method(method);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private CropAndResizeGradImage(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private String method;

        public Options method(String method) {
            this.method = method;
            return this;
        }

        private Options() {
        }
    }
}

