/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class TextLineReader
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "TextLineReaderV2";
    private Output<?> readerHandle;

    public static TextLineReader create(Scope scope, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName("TextLineReader"));
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.skipHeaderLines != null) {
                    opBuilder.setAttr("skip_header_lines", opts.skipHeaderLines);
                }
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName == null) continue;
                opBuilder.setAttr("shared_name", opts.sharedName);
            }
        }
        return new TextLineReader(opBuilder.build());
    }

    public static Options skipHeaderLines(Long skipHeaderLines) {
        return new Options().skipHeaderLines(skipHeaderLines);
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public Output<?> readerHandle() {
        return this.readerHandle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.readerHandle;
    }

    private TextLineReader(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.readerHandle = operation.output(outputIdx++);
    }

    public static class Options {
        private Long skipHeaderLines;
        private String container;
        private String sharedName;

        public Options skipHeaderLines(Long skipHeaderLines) {
            this.skipHeaderLines = skipHeaderLines;
            return this;
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        private Options() {
        }
    }
}

