/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;

public final class AnonymousMultiDeviceIterator
extends RawOp {
    public static final String OP_NAME = "AnonymousMultiDeviceIterator";
    private Output<?> handle;
    private Output<?> deleter;

    public static AnonymousMultiDeviceIterator create(Scope scope, List<String> devices, List<DataType<?>> outputTypes, List<Shape> outputShapes) {
        OperationBuilder opBuilder = scope.env().opBuilder(OP_NAME, scope.makeOpName(OP_NAME));
        opBuilder = scope.applyControlDependencies(opBuilder);
        String[] devicesArray = new String[devices.size()];
        for (int i = 0; i < devicesArray.length; ++i) {
            devicesArray[i] = devices.get(i);
        }
        opBuilder.setAttr("devices", devicesArray);
        DataType[] outputTypesArray = new DataType[outputTypes.size()];
        for (int i = 0; i < outputTypesArray.length; ++i) {
            outputTypesArray[i] = outputTypes.get(i);
        }
        opBuilder.setAttr("output_types", outputTypesArray);
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        return new AnonymousMultiDeviceIterator(opBuilder.build());
    }

    public Output<?> handle() {
        return this.handle;
    }

    public Output<?> deleter() {
        return this.deleter;
    }

    private AnonymousMultiDeviceIterator(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
        this.deleter = operation.output(outputIdx++);
    }
}

