/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.Graph;
import org.tensorflow.Session;
import org.tensorflow.Signature;
import org.tensorflow.Tensor;
import org.tensorflow.TensorFlow;
import org.tensorflow.exceptions.TensorFlowException;
import org.tensorflow.internal.c_api.TF_Buffer;
import org.tensorflow.internal.c_api.TF_Graph;
import org.tensorflow.internal.c_api.TF_Session;
import org.tensorflow.internal.c_api.TF_SessionOptions;
import org.tensorflow.internal.c_api.TF_Status;
import org.tensorflow.internal.c_api.global.tensorflow;
import org.tensorflow.proto.framework.ConfigProto;
import org.tensorflow.proto.framework.MetaGraphDef;
import org.tensorflow.proto.framework.RunOptions;
import org.tensorflow.proto.framework.SavedModel;
import org.tensorflow.proto.framework.SignatureDef;
import org.tensorflow.proto.util.SaverDef;

public class SavedModelBundle
implements AutoCloseable {
    public static final String DEFAULT_TAG = "serve";
    private final Graph graph;
    private final Session session;
    private final MetaGraphDef metaGraphDef;
    private final Map<String, ConcreteFunction> functions;

    public static SavedModelBundle load(String exportDir, String ... tags) {
        Loader loader = SavedModelBundle.loader(exportDir);
        if (tags != null && tags.length > 0) {
            loader.withTags(tags);
        }
        return loader.load();
    }

    public static Loader loader(String exportDir) {
        return new Loader(exportDir);
    }

    public static Exporter exporter(String exportDir) {
        return new Exporter(exportDir);
    }

    public MetaGraphDef metaGraphDef() {
        return this.metaGraphDef;
    }

    public Graph graph() {
        return this.graph;
    }

    public Session session() {
        return this.session;
    }

    public List<Signature> signatures() {
        return this.functions.values().stream().map(f -> f.signature()).collect(Collectors.toList());
    }

    public ConcreteFunction function(String signatureKey) {
        ConcreteFunction function = this.functions.get(signatureKey);
        if (function == null) {
            throw new IllegalArgumentException(String.format("Function with signature [%s] not found", signatureKey));
        }
        return function;
    }

    public Map<String, Tensor<?>> call(Map<String, Tensor<?>> arguments) {
        ConcreteFunction function = null;
        function = this.functions.size() == 1 ? this.functions.values().iterator().next() : this.functions.get("serving_default");
        if (function == null) {
            throw new IllegalArgumentException("Cannot elect a default function for this model");
        }
        return function.call(arguments);
    }

    @Override
    public void close() {
        this.session.close();
        this.graph.close();
    }

    private SavedModelBundle(Graph graph, Session session, MetaGraphDef metaGraphDef, Map<String, ConcreteFunction> functions) {
        this.graph = graph;
        this.session = session;
        this.metaGraphDef = metaGraphDef;
        this.functions = functions;
    }

    private static SavedModelBundle fromHandle(TF_Graph graphHandle, TF_Session sessionHandle, MetaGraphDef metaGraphDef) {
        Graph graph = new Graph(graphHandle, metaGraphDef.getSaverDef());
        Session session = new Session(graph, sessionHandle);
        HashMap<String, ConcreteFunction> functions = new HashMap<String, ConcreteFunction>(metaGraphDef.getSignatureDefCount());
        metaGraphDef.getSignatureDefMap().forEach((signatureName, signatureDef) -> {
            Signature signature = new Signature((String)signatureName, (SignatureDef)signatureDef);
            functions.put((String)signatureName, ConcreteFunction.create(signature, session));
        });
        return new SavedModelBundle(graph, session, metaGraphDef, functions);
    }

    private static SavedModelBundle load(String exportDir, String[] tags, ConfigProto config, RunOptions runOptions) {
        SavedModelBundle bundle = null;
        try (PointerScope scope = new PointerScope(new Class[0]);){
            TF_Status status = TF_Status.newStatus();
            TF_SessionOptions opts = TF_SessionOptions.newSessionOptions();
            if (config != null) {
                BytePointer configBytes = new BytePointer(config.toByteArray());
                tensorflow.TF_SetConfig(opts, (Pointer)configBytes, configBytes.capacity(), status);
                status.throwExceptionIfNotOK();
            }
            TF_Buffer runOpts = TF_Buffer.newBufferFromString((Message)runOptions);
            TF_Graph graph = tensorflow.TF_NewGraph();
            TF_Buffer metagraphDef = TF_Buffer.newBuffer();
            TF_Session session = tensorflow.TF_LoadSessionFromSavedModel(opts, runOpts, new BytePointer(exportDir), new PointerPointer(tags), tags.length, graph, metagraphDef, status);
            status.throwExceptionIfNotOK();
            try {
                bundle = SavedModelBundle.fromHandle(graph, session, MetaGraphDef.parseFrom(metagraphDef.dataAsByteBuffer()));
            }
            catch (InvalidProtocolBufferException e) {
                throw new TensorFlowException("Cannot parse MetaGraphDef protocol buffer", e);
            }
        }
        return bundle;
    }

    private static void validateTags(String[] tags) {
        if (tags == null || tags.length == 0 || Arrays.stream(tags).anyMatch(t -> t == null || t.isEmpty())) {
            throw new IllegalArgumentException("Invalid tags: " + Arrays.toString(tags));
        }
    }

    static {
        TensorFlow.init();
    }

    public static final class Exporter {
        private final String exportDir;
        private String[] tags = new String[]{"serve"};
        private final MetaGraphDef.Builder metaGraphDefBuilder = MetaGraphDef.newBuilder();
        private final Map<String, ConcreteFunction> functions = new LinkedHashMap<String, ConcreteFunction>();
        private Session session;

        public Exporter withTags(String ... tags) {
            SavedModelBundle.validateTags(tags);
            this.tags = tags;
            return this;
        }

        public Exporter withFunction(ConcreteFunction function) {
            Signature signature = function.signature();
            if (this.functions.containsKey(signature.key())) {
                throw new IllegalArgumentException("Function \"" + signature.key() + "\" was already added to the model");
            }
            this.functions.put(signature.key(), function);
            if (this.session == null) {
                this.session = function.session();
            } else if (this.session != function.session()) {
                throw new UnsupportedOperationException("Saving multiple functions with different graphs/sessions is not supported yet.");
            }
            this.metaGraphDefBuilder.putSignatureDef(signature.key(), signature.asSignatureDef());
            return this;
        }

        public void export() throws IOException {
            if (this.functions.isEmpty() || this.session == null) {
                throw new IllegalStateException("Model should contain at least one valid function");
            }
            Graph graph = this.session.graph();
            SaverDef saverDef = graph.saverDef();
            MetaGraphDef.Builder metaGraphDef = this.metaGraphDefBuilder.setSaverDef(saverDef).setGraphDef(graph.toGraphDef()).setMetaInfoDef(MetaGraphDef.MetaInfoDef.newBuilder().addAllTags(Arrays.asList(this.tags)));
            this.functions.forEach((k, f) -> metaGraphDef.putSignatureDef((String)k, f.signature().asSignatureDef()));
            Path variableDir = Paths.get(this.exportDir, "variables");
            variableDir.toFile().mkdirs();
            this.session.save(variableDir.resolve("variables").toString());
            SavedModel savedModelDef = SavedModel.newBuilder().addMetaGraphs(metaGraphDef).build();
            try (FileOutputStream file = new FileOutputStream(Paths.get(this.exportDir, "saved_model.pb").toString());){
                savedModelDef.writeTo(file);
            }
        }

        Exporter(String exportDir) {
            this.exportDir = exportDir;
        }
    }

    public static final class Loader {
        private String exportDir = null;
        private String[] tags = new String[]{"serve"};
        private ConfigProto configProto = null;
        private RunOptions runOptions = null;

        public SavedModelBundle load() {
            return SavedModelBundle.load(this.exportDir, this.tags, this.configProto, this.runOptions);
        }

        public Loader withRunOptions(RunOptions options) {
            this.runOptions = options;
            return this;
        }

        public Loader withConfigProto(ConfigProto configProto) {
            this.configProto = configProto;
            return this;
        }

        public Loader withTags(String ... tags) {
            SavedModelBundle.validateTags(tags);
            this.tags = tags;
            return this;
        }

        private Loader(String exportDir) {
            this.exportDir = exportDir;
        }
    }
}

