/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.pytorch.engine;

import ai.djl.Device;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.internal.NDFormat;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.ndarray.types.SparseFormat;
import ai.djl.pytorch.engine.PtNDArrayEx;
import ai.djl.pytorch.engine.PtNDManager;
import ai.djl.pytorch.jni.JniUtils;
import ai.djl.pytorch.jni.NativeResource;
import ai.djl.pytorch.jni.Pointer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PtNDArray
extends NativeResource
implements NDArray {
    private static final int MAX_SIZE = 100;
    private static final int MAX_DEPTH = 10;
    private static final int MAX_ROWS = 10;
    private static final int MAX_COLUMNS = 20;
    private String name;
    private Device device;
    private DataType dataType;
    private Shape shape;
    private SparseFormat sparseFormat;
    private Boolean hasGradient;
    private PtNDManager manager;
    private PtNDArrayEx ptNDArrayEx;

    PtNDArray(PtNDManager manager, Pointer handle) {
        super(handle);
        this.manager = manager;
        this.ptNDArrayEx = new PtNDArrayEx(this);
        manager.attach(this.getUid(), this);
    }

    public PtNDManager getManager() {
        return this.manager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DataType getDataType() {
        if (this.dataType == null) {
            this.dataType = JniUtils.getDataType(this);
        }
        return this.dataType;
    }

    public Device getDevice() {
        if (this.device == null) {
            this.device = JniUtils.getDevice(this);
        }
        return this.device;
    }

    public Shape getShape() {
        if (this.shape == null) {
            this.shape = JniUtils.getShape(this);
        }
        return this.shape;
    }

    public SparseFormat getSparseFormat() {
        if (this.sparseFormat == null) {
            this.sparseFormat = JniUtils.getSparseFormat(this);
        }
        return this.sparseFormat;
    }

    public PtNDArray toDevice(Device device, boolean copy) {
        return JniUtils.to(this, this.getDataType(), device, copy);
    }

    public PtNDArray toType(DataType dataType, boolean copy) {
        return JniUtils.to(this, dataType, this.getDevice(), copy);
    }

    public void attachGradient() {
        this.attachGradient(null);
    }

    public void attachGradient(SparseFormat sparseFormat) {
        if (sparseFormat != null && !sparseFormat.equals((Object)SparseFormat.DENSE)) {
            throw new UnsupportedOperationException("Sparse NDArray gradient atttach not supported");
        }
        JniUtils.attachGradient(this);
        this.hasGradient = true;
    }

    public PtNDArray getGradient() {
        if (!this.hasGradient()) {
            throw new IllegalStateException("No gradient attached to this NDArray, please call array.requiredGradient()on your NDArray or block.setInitializer() on your Block");
        }
        PtNDArray res = JniUtils.getGradient(this);
        if (res == null) {
            res = (PtNDArray)this.getManager().zeros(this.getShape());
        }
        return res;
    }

    public boolean hasGradient() {
        if (this.hasGradient == null) {
            this.hasGradient = JniUtils.requiresGrad(this);
        }
        return this.hasGradient;
    }

    public ByteBuffer toByteBuffer() {
        return JniUtils.getByteBuffer(this);
    }

    public void set(Buffer data) {
        PtNDArray other = this.getManager().create(data, this.getShape(), this.getDataType());
        JniUtils.set(this, other);
        other.close();
    }

    public void copyTo(NDArray array) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDManager attach(NDManager manager) {
        this.detach();
        PtNDManager original = this.manager;
        this.manager = (PtNDManager)manager;
        manager.attach(this.getUid(), (AutoCloseable)this);
        return original;
    }

    public void detach() {
        this.manager.detach(this.getUid());
        this.manager = PtNDManager.getSystemManager();
    }

    public NDArray duplicate() {
        return JniUtils.clone(this);
    }

    public PtNDArray booleanMask(NDArray index, int axis) {
        Shape indexShape = index.getShape();
        if (indexShape.equals((Object)this.getShape())) {
            return JniUtils.booleanMask(this, (PtNDArray)index);
        }
        if (indexShape.equals((Object)this.getShape().slice(axis))) {
            try (PtNDArray flattedResult = JniUtils.booleanMask(this, (PtNDArray)index);){
                Shape remainder = this.getShape().slice(0, axis);
                long selectedSize = flattedResult.getShape().size() / remainder.size();
                PtNDArray ptNDArray = flattedResult.reshape(remainder.addAll(new Shape(new long[]{selectedSize})));
                return ptNDArray;
            }
        }
        throw new UnsupportedOperationException("Not supported for shape not broadcastable " + indexShape.toString() + " vs " + this.getShape().toString());
    }

    public NDArray sequenceMask(NDArray sequenceLength, float value) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public NDArray sequenceMask(NDArray sequenceLength) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public PtNDArray zerosLike() {
        return JniUtils.zerosLike(this, this.getDataType(), this.getDevice(), SparseFormat.DENSE);
    }

    public PtNDArray onesLike() {
        return JniUtils.onesLike(this, this.getDataType(), this.getDevice(), SparseFormat.DENSE);
    }

    public boolean contentEquals(Number number) {
        return JniUtils.contentEqual(this, (PtNDArray)this.manager.create(number));
    }

    public boolean contentEquals(NDArray other) {
        if (other == null || !this.shapeEquals(other)) {
            return false;
        }
        if (this.getDataType() != other.getDataType()) {
            return false;
        }
        return JniUtils.contentEqual(this, (PtNDArray)other);
    }

    public PtNDArray eq(Number n) {
        try (NDArray number = this.manager.create(n);){
            PtNDArray ptNDArray = this.eq(number);
            return ptNDArray;
        }
    }

    public PtNDArray eq(NDArray other) {
        return JniUtils.eq(this, (PtNDArray)other);
    }

    public PtNDArray neq(Number n) {
        try (NDArray number = this.manager.create(n);){
            PtNDArray ptNDArray = this.neq(number);
            return ptNDArray;
        }
    }

    public PtNDArray neq(NDArray other) {
        return JniUtils.neq(this, (PtNDArray)other);
    }

    public PtNDArray gt(Number n) {
        try (NDArray number = this.manager.create(n);){
            PtNDArray ptNDArray = this.gt(number);
            return ptNDArray;
        }
    }

    public PtNDArray gt(NDArray other) {
        return JniUtils.gt(this, (PtNDArray)other);
    }

    public PtNDArray gte(Number n) {
        try (NDArray number = this.manager.create(n);){
            PtNDArray ptNDArray = this.gte(number);
            return ptNDArray;
        }
    }

    public PtNDArray gte(NDArray other) {
        return JniUtils.gte(this, (PtNDArray)other);
    }

    public PtNDArray lt(Number n) {
        try (NDArray number = this.manager.create(n);){
            PtNDArray ptNDArray = this.lt(number);
            return ptNDArray;
        }
    }

    public PtNDArray lt(NDArray other) {
        return JniUtils.lt(this, (PtNDArray)other);
    }

    public PtNDArray lte(Number n) {
        try (NDArray number = this.manager.create(n);){
            PtNDArray ptNDArray = this.lte(number);
            return ptNDArray;
        }
    }

    public PtNDArray lte(NDArray other) {
        return JniUtils.lte(this, (PtNDArray)other);
    }

    public PtNDArray add(Number n) {
        try (NDArray number = this.manager.create(n);){
            PtNDArray ptNDArray = this.add(number);
            return ptNDArray;
        }
    }

    public PtNDArray add(NDArray other) {
        return JniUtils.add(this, (PtNDArray)other);
    }

    public PtNDArray sub(Number n) {
        try (NDArray number = this.manager.create(n);){
            PtNDArray ptNDArray = this.sub(number);
            return ptNDArray;
        }
    }

    public PtNDArray sub(NDArray other) {
        return JniUtils.sub(this, (PtNDArray)other);
    }

    public PtNDArray mul(Number n) {
        try (NDArray number = this.manager.create(n);){
            PtNDArray ptNDArray = this.mul(number);
            return ptNDArray;
        }
    }

    public PtNDArray mul(NDArray other) {
        return JniUtils.mul(this, (PtNDArray)other);
    }

    public PtNDArray div(Number n) {
        try (NDArray number = this.manager.create(n);){
            PtNDArray ptNDArray = this.div(number);
            return ptNDArray;
        }
    }

    public PtNDArray div(NDArray other) {
        return JniUtils.div(this, (PtNDArray)other);
    }

    public PtNDArray mod(Number n) {
        try (NDArray number = this.manager.create(n);){
            PtNDArray ptNDArray = this.mod(number);
            return ptNDArray;
        }
    }

    public PtNDArray mod(NDArray other) {
        return JniUtils.remainder(this, (PtNDArray)other);
    }

    public PtNDArray pow(Number n) {
        try (NDArray number = this.manager.create(n);){
            PtNDArray ptNDArray = this.pow(number);
            return ptNDArray;
        }
    }

    public PtNDArray pow(NDArray other) {
        return JniUtils.pow(this, (PtNDArray)other);
    }

    public PtNDArray addi(Number n) {
        try (NDArray number = this.manager.create(n);){
            PtNDArray ptNDArray = this.addi(number);
            return ptNDArray;
        }
    }

    public PtNDArray addi(NDArray other) {
        JniUtils.addi(this, (PtNDArray)other);
        return this;
    }

    public PtNDArray subi(Number n) {
        try (NDArray number = this.manager.create(n);){
            PtNDArray ptNDArray = this.subi(number);
            return ptNDArray;
        }
    }

    public PtNDArray subi(NDArray other) {
        JniUtils.subi(this, (PtNDArray)other);
        return this;
    }

    public PtNDArray muli(Number n) {
        try (NDArray number = this.manager.create(n);){
            PtNDArray ptNDArray = this.muli(number);
            return ptNDArray;
        }
    }

    public PtNDArray muli(NDArray other) {
        JniUtils.muli(this, (PtNDArray)other);
        return this;
    }

    public PtNDArray divi(Number n) {
        try (NDArray number = this.manager.create(n);){
            PtNDArray ptNDArray = this.divi(number);
            return ptNDArray;
        }
    }

    public PtNDArray divi(NDArray other) {
        JniUtils.divi(this, (PtNDArray)other);
        return this;
    }

    public PtNDArray modi(Number n) {
        try (NDArray number = this.manager.create(n);){
            PtNDArray ptNDArray = this.modi(number);
            return ptNDArray;
        }
    }

    public PtNDArray modi(NDArray other) {
        JniUtils.remainderi(this, (PtNDArray)other);
        return this;
    }

    public PtNDArray powi(Number n) {
        try (NDArray number = this.manager.create(n);){
            PtNDArray ptNDArray = this.powi(number);
            return ptNDArray;
        }
    }

    public PtNDArray powi(NDArray other) {
        JniUtils.powi(this, (PtNDArray)other);
        return this;
    }

    public PtNDArray sign() {
        return JniUtils.sign(this);
    }

    public PtNDArray signi() {
        JniUtils.signi(this);
        return this;
    }

    public PtNDArray maximum(Number n) {
        try (NDArray number = this.manager.create(n);){
            PtNDArray ptNDArray = this.maximum(number);
            return ptNDArray;
        }
    }

    public PtNDArray maximum(NDArray other) {
        return JniUtils.max(this, (PtNDArray)other);
    }

    public PtNDArray minimum(Number n) {
        try (NDArray number = this.manager.create(n);){
            PtNDArray ptNDArray = this.minimum(number);
            return ptNDArray;
        }
    }

    public PtNDArray minimum(NDArray other) {
        return JniUtils.min(this, (PtNDArray)other);
    }

    public PtNDArray all() {
        try (PtNDArray bool = this.toType(DataType.BOOLEAN, true);){
            PtNDArray ptNDArray = JniUtils.all(bool);
            return ptNDArray;
        }
    }

    public PtNDArray any() {
        try (PtNDArray bool = this.toType(DataType.BOOLEAN, true);){
            PtNDArray ptNDArray = JniUtils.any(bool);
            return ptNDArray;
        }
    }

    public PtNDArray none() {
        try (PtNDArray bool = this.toType(DataType.BOOLEAN, true);){
            PtNDArray ptNDArray = JniUtils.none(bool);
            return ptNDArray;
        }
    }

    public PtNDArray neg() {
        return JniUtils.neg(this);
    }

    public PtNDArray negi() {
        JniUtils.negi(this);
        return this;
    }

    public PtNDArray abs() {
        return JniUtils.abs(this);
    }

    public PtNDArray square() {
        return JniUtils.square(this);
    }

    public NDArray sqrt() {
        return JniUtils.sqrt(this);
    }

    public PtNDArray cbrt() {
        return JniUtils.pow(this, (PtNDArray)this.getManager().create(0.3333333333333333));
    }

    public PtNDArray floor() {
        return JniUtils.floor(this);
    }

    public PtNDArray ceil() {
        return JniUtils.ceil(this);
    }

    public PtNDArray round() {
        return JniUtils.round(this);
    }

    public PtNDArray trunc() {
        return JniUtils.trunc(this);
    }

    public PtNDArray exp() {
        return JniUtils.exp(this);
    }

    public PtNDArray log() {
        return JniUtils.log(this);
    }

    public PtNDArray log10() {
        return JniUtils.log10(this);
    }

    public PtNDArray log2() {
        return JniUtils.log2(this);
    }

    public PtNDArray sin() {
        return JniUtils.sin(this);
    }

    public PtNDArray cos() {
        return JniUtils.cos(this);
    }

    public PtNDArray tan() {
        return JniUtils.tan(this);
    }

    public PtNDArray asin() {
        return JniUtils.asin(this);
    }

    public PtNDArray acos() {
        return JniUtils.acos(this);
    }

    public PtNDArray atan() {
        return JniUtils.atan(this);
    }

    public PtNDArray sinh() {
        return JniUtils.sinh(this);
    }

    public PtNDArray cosh() {
        return JniUtils.cosh(this);
    }

    public PtNDArray tanh() {
        return JniUtils.tanh(this);
    }

    public PtNDArray asinh() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public PtNDArray acosh() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public PtNDArray atanh() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public PtNDArray toDegrees() {
        return this.mul(180.0).div(Math.PI);
    }

    public PtNDArray toRadians() {
        return this.mul(Math.PI).div(180.0);
    }

    public PtNDArray max() {
        return JniUtils.max(this);
    }

    public PtNDArray max(int[] axes, boolean keepDims) {
        if (axes.length > 1) {
            throw new UnsupportedOperationException("Only 1 axis is support!");
        }
        return JniUtils.max(this, axes[0], keepDims);
    }

    public PtNDArray min() {
        return JniUtils.min(this);
    }

    public PtNDArray min(int[] axes, boolean keepDims) {
        if (axes.length > 1) {
            throw new UnsupportedOperationException("Only 1 axis is support!");
        }
        return JniUtils.min(this, axes[0], keepDims);
    }

    public PtNDArray sum() {
        return JniUtils.sum(this);
    }

    public PtNDArray sum(int[] axes, boolean keepDims) {
        return JniUtils.sum(this, Arrays.stream(axes).mapToLong(i -> i).toArray(), keepDims);
    }

    public PtNDArray prod() {
        return JniUtils.prod(this);
    }

    public PtNDArray prod(int[] axes, boolean keepDims) {
        if (axes.length > 1) {
            throw new UnsupportedOperationException("Only 1 axis is support!");
        }
        return JniUtils.prod(this, axes[0], keepDims);
    }

    public PtNDArray mean() {
        return JniUtils.mean(this);
    }

    public PtNDArray mean(int[] axes, boolean keepDims) {
        if (axes.length > 1) {
            throw new UnsupportedOperationException("Only 1 axis is support!");
        }
        return JniUtils.mean(this, axes[0], keepDims);
    }

    public PtNDArray trace(int offset, int axis1, int axis2) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList split(long sections, int axis) {
        long size = this.getShape().get(axis) / sections;
        return JniUtils.split(this, size, (long)axis);
    }

    public NDList split(long[] indices, int axis) {
        if (indices.length == 0) {
            return new NDList(new NDArray[]{this});
        }
        ArrayList<Long> ptIndex = new ArrayList<Long>();
        ptIndex.add(indices[0]);
        for (int i2 = 1; i2 < indices.length; ++i2) {
            ptIndex.add(indices[i2] - indices[i2 - 1]);
        }
        ptIndex.add(this.size(axis) - indices[indices.length - 1]);
        return JniUtils.split(this, ptIndex.stream().mapToLong(i -> i).toArray(), (long)axis);
    }

    public PtNDArray flatten() {
        return JniUtils.flatten(this, 0L, -1L);
    }

    public PtNDArray reshape(Shape shape) {
        return JniUtils.reshape(this, shape.getShape());
    }

    public PtNDArray expandDims(int axis) {
        return JniUtils.unsqueeze(this, axis);
    }

    public PtNDArray squeeze() {
        return JniUtils.squeeze(this);
    }

    public PtNDArray squeeze(int axis) {
        return JniUtils.squeeze(this, axis);
    }

    public PtNDArray squeeze(int[] axes) {
        if (this.isScalar()) {
            if (axes.length > 1 || axes[0] != 0) {
                throw new IllegalArgumentException("axis " + axes[0] + "is out of bounds for array of dimension 0");
            }
            return (PtNDArray)this.duplicate();
        }
        long[] shapeArr = this.getShape().getShape();
        ArrayList<Long> newShape = new ArrayList<Long>();
        Set set = IntStream.of(axes).boxed().collect(Collectors.toCollection(HashSet::new));
        for (int axis : axes) {
            if (shapeArr[axis] == 1L) continue;
            throw new IllegalArgumentException("cannot select an axis to squeeze out which has size not equal to one");
        }
        for (int i2 = 0; i2 < shapeArr.length; ++i2) {
            if (set.contains(i2)) continue;
            newShape.add(shapeArr[i2]);
        }
        return (PtNDArray)this.reshape(newShape.stream().mapToLong(i -> i).toArray());
    }

    public PtNDArray logicalAnd(NDArray other) {
        return JniUtils.logicalAnd(this, (PtNDArray)other);
    }

    public PtNDArray logicalOr(NDArray other) {
        return JniUtils.logicalOr(this, (PtNDArray)other);
    }

    public PtNDArray logicalXor(NDArray other) {
        return JniUtils.logicalXor(this, (PtNDArray)other);
    }

    public PtNDArray logicalNot() {
        return JniUtils.logicalNot(this);
    }

    public PtNDArray argSort(int axis, boolean ascending) {
        if (!ascending) {
            throw new UnsupportedOperationException("Only support ascending!");
        }
        return JniUtils.argSort(this, axis, false);
    }

    public PtNDArray sort() {
        return this.sort(-1);
    }

    public PtNDArray sort(int axis) {
        return JniUtils.sort(this, axis, false);
    }

    public PtNDArray softmax(int axis) {
        return JniUtils.softmax(this, axis, this.getDataType());
    }

    public PtNDArray logSoftmax(int axis) {
        return JniUtils.logSoftmax(this, axis, this.getDataType());
    }

    public PtNDArray cumSum() {
        if (this.isScalar()) {
            return (PtNDArray)this.reshape(new long[]{1L});
        }
        if (this.isEmpty()) {
            return (PtNDArray)this.reshape(new long[]{0L});
        }
        return this.cumSum(0);
    }

    public PtNDArray cumSum(int axis) {
        return JniUtils.cumSum(this, axis);
    }

    public PtNDArray isInfinite() {
        return JniUtils.isInf(this);
    }

    public PtNDArray isNaN() {
        return JniUtils.isNaN(this);
    }

    public PtNDArray tile(long repeats) {
        if (this.isEmpty()) {
            return (PtNDArray)this.duplicate();
        }
        int dim = this.isScalar() ? 1 : this.getShape().dimension();
        long[] repeatsArray = new long[dim];
        Arrays.fill(repeatsArray, repeats);
        return this.tile(repeatsArray);
    }

    public PtNDArray tile(int axis, long repeats) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public PtNDArray tile(long[] repeats) {
        return JniUtils.tile(this, repeats);
    }

    public PtNDArray tile(Shape desiredShape) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public PtNDArray repeat(long repeats) {
        if (this.isEmpty()) {
            return (PtNDArray)this.duplicate();
        }
        int dim = this.isScalar() ? 1 : this.getShape().dimension();
        long[] repeatsArray = new long[dim];
        Arrays.fill(repeatsArray, repeats);
        return this.repeat(repeatsArray);
    }

    public PtNDArray repeat(int axis, long repeats) {
        return JniUtils.repeat(this, repeats, axis);
    }

    public PtNDArray repeat(long[] repeats) {
        PtNDArray result = this;
        for (int dim = 0; dim < repeats.length; ++dim) {
            PtNDArray temp = result;
            result = JniUtils.repeat(result, repeats[dim], dim);
            if (temp == this) continue;
            temp.close();
        }
        return result;
    }

    public PtNDArray repeat(Shape desiredShape) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public PtNDArray dot(NDArray other) {
        int otherDim;
        int selfDim = this.getShape().dimension();
        if (selfDim != (otherDim = other.getShape().dimension()) || selfDim > 2) {
            throw new UnsupportedOperationException("Dimension mismatch or high dimensional dot operation is not supported. Please use .matMul instead.");
        }
        return JniUtils.dot(this, (PtNDArray)other);
    }

    public NDArray matMul(NDArray other) {
        if (this.isScalar() || other.isScalar()) {
            throw new IllegalArgumentException("scalar is not allowed for matMul()");
        }
        return JniUtils.matmul(this, (PtNDArray)other);
    }

    public PtNDArray clip(Number min, Number max) {
        return JniUtils.clip(this, min, max);
    }

    public PtNDArray swapAxes(int axis1, int axis2) {
        return JniUtils.transpose(this, axis1, axis2);
    }

    public NDArray flip(int ... axes) {
        return JniUtils.flip(this, Arrays.stream(axes).mapToLong(ele -> ele).toArray());
    }

    public PtNDArray transpose() {
        int dim = this.getShape().dimension();
        int[] reversedShape = IntStream.range(0, dim).map(i -> dim - i - 1).toArray();
        return this.transpose(reversedShape);
    }

    public PtNDArray transpose(int ... axes) {
        if (this.isScalar() && axes.length > 0) {
            throw new IllegalArgumentException("axes don't match NDArray");
        }
        return JniUtils.permute(this, Arrays.stream(axes).mapToLong(i -> i).toArray());
    }

    public PtNDArray broadcast(Shape shape) {
        return JniUtils.broadcast(this, shape);
    }

    public PtNDArray argMax() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("attempt to get argMax of an empty NDArray");
        }
        return JniUtils.argMax(this);
    }

    public PtNDArray argMax(int axis) {
        if (this.isScalar()) {
            return (PtNDArray)this.manager.create(0L);
        }
        return JniUtils.argMax(this, axis, false);
    }

    public PtNDArray argMin() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("attempt to get argMin of an empty NDArray");
        }
        return JniUtils.argMin(this);
    }

    public PtNDArray argMin(int axis) {
        if (this.isScalar()) {
            return (PtNDArray)this.manager.create(0L);
        }
        return JniUtils.argMin(this, axis, false);
    }

    public PtNDArray percentile(Number percentile) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public PtNDArray percentile(Number percentile, int[] axes) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public PtNDArray median() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public PtNDArray median(int[] axes) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public PtNDArray toDense() {
        if (!this.isSparse() && JniUtils.getLayout(this) != 2) {
            return (PtNDArray)this.duplicate();
        }
        return JniUtils.toDense(this);
    }

    public PtNDArray toSparse(SparseFormat fmt) {
        if (fmt == SparseFormat.DENSE) {
            throw new IllegalArgumentException("Default type is not allowed");
        }
        if (fmt != SparseFormat.COO) {
            throw new UnsupportedOperationException("Only COO sparse type supported for PyTorch");
        }
        if (fmt == this.getSparseFormat()) {
            return (PtNDArray)this.duplicate();
        }
        return JniUtils.toSparse(this);
    }

    public PtNDArray nonzero() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public PtNDArray erfinv() {
        return JniUtils.erfinv(this);
    }

    public PtNDArrayEx getNDArrayInternal() {
        return this.ptNDArrayEx;
    }

    public String toString() {
        if (this.isReleased()) {
            return "This array is already closed";
        }
        if (JniUtils.getLayout(this) != 0) {
            try (PtNDArray tmp = this.toDense();){
                String string = NDFormat.format((NDArray)tmp, (int)100, (int)10, (int)10, (int)20);
                return string;
            }
        }
        return this.toDebugString(100, 10, 10, 20);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PtNDArray) {
            return this.contentEquals((PtNDArray)obj);
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public void close() {
        Pointer pointer = this.handle.getAndSet(null);
        if (pointer != null) {
            JniUtils.deleteNdArray(pointer);
            this.manager.detach(this.getUid());
            this.manager = null;
        }
    }
}

