/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.OnnxRuntime;
import ai.onnxruntime.OrtAllocator;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtLoggingLevel;
import ai.onnxruntime.OrtSession;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class OrtEnvironment
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(OrtEnvironment.class.getName());
    public static final String DEFAULT_NAME = "ort-java";
    private static volatile OrtEnvironment INSTANCE;
    private static final AtomicInteger refCount;
    private static volatile OrtLoggingLevel curLogLevel;
    private static volatile String curLoggingName;
    final long nativeHandle;
    final OrtAllocator defaultAllocator;
    private volatile boolean closed = false;

    public static OrtEnvironment getEnvironment() {
        return OrtEnvironment.getEnvironment(OrtLoggingLevel.ORT_LOGGING_LEVEL_WARNING, DEFAULT_NAME);
    }

    public static OrtEnvironment getEnvironment(String name) {
        return OrtEnvironment.getEnvironment(OrtLoggingLevel.ORT_LOGGING_LEVEL_WARNING, name);
    }

    public static OrtEnvironment getEnvironment(OrtLoggingLevel logLevel) {
        return OrtEnvironment.getEnvironment(logLevel, DEFAULT_NAME);
    }

    public static synchronized OrtEnvironment getEnvironment(OrtLoggingLevel loggingLevel, String name) {
        if (INSTANCE == null) {
            try {
                INSTANCE = new OrtEnvironment(loggingLevel, name);
                curLogLevel = loggingLevel;
                curLoggingName = name;
            }
            catch (OrtException e) {
                throw new IllegalStateException("Failed to create OrtEnvironment", e);
            }
        } else if (loggingLevel.getValue() != curLogLevel.getValue() || !name.equals(curLoggingName)) {
            logger.warning("Tried to change OrtEnvironment's logging level or name while a reference exists.");
        }
        refCount.incrementAndGet();
        return INSTANCE;
    }

    private OrtEnvironment() throws OrtException {
        this(OrtLoggingLevel.ORT_LOGGING_LEVEL_WARNING, "java-default");
    }

    private OrtEnvironment(OrtLoggingLevel loggingLevel, String name) throws OrtException {
        this.nativeHandle = OrtEnvironment.createHandle(OnnxRuntime.ortApiHandle, loggingLevel.getValue(), name);
        this.defaultAllocator = new OrtAllocator(OrtEnvironment.getDefaultAllocator(OnnxRuntime.ortApiHandle), true);
    }

    public OrtSession createSession(String modelPath) throws OrtException {
        return this.createSession(modelPath, new OrtSession.SessionOptions());
    }

    public OrtSession createSession(String modelPath, OrtSession.SessionOptions options) throws OrtException {
        return this.createSession(modelPath, this.defaultAllocator, options);
    }

    OrtSession createSession(String modelPath, OrtAllocator allocator, OrtSession.SessionOptions options) throws OrtException {
        if (!this.closed) {
            return new OrtSession(this, modelPath, allocator, options);
        }
        throw new IllegalStateException("Trying to create an OrtSession on a closed OrtEnvironment.");
    }

    public OrtSession createSession(byte[] modelArray, OrtSession.SessionOptions options) throws OrtException {
        return this.createSession(modelArray, this.defaultAllocator, options);
    }

    public OrtSession createSession(byte[] modelArray) throws OrtException {
        return this.createSession(modelArray, new OrtSession.SessionOptions());
    }

    OrtSession createSession(byte[] modelArray, OrtAllocator allocator, OrtSession.SessionOptions options) throws OrtException {
        if (!this.closed) {
            return new OrtSession(this, modelArray, allocator, options);
        }
        throw new IllegalStateException("Trying to create an OrtSession on a closed OrtEnvironment.");
    }

    public void setTelemetry(boolean sendTelemetry) throws OrtException {
        OrtEnvironment.setTelemetry(OnnxRuntime.ortApiHandle, this.nativeHandle, sendTelemetry);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String toString() {
        return "OrtEnvironment(name=" + curLoggingName + ",logLevel=" + (Object)((Object)curLogLevel) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws OrtException {
        AtomicInteger atomicInteger = refCount;
        synchronized (atomicInteger) {
            int curCount = refCount.get();
            if (curCount != 0) {
                refCount.decrementAndGet();
            }
            if (curCount == 1) {
                OrtEnvironment.close(OnnxRuntime.ortApiHandle, this.nativeHandle);
                this.closed = true;
                INSTANCE = null;
            }
        }
    }

    private static native long createHandle(long var0, int var2, String var3) throws OrtException;

    private static native long getDefaultAllocator(long var0) throws OrtException;

    private static native void close(long var0, long var2) throws OrtException;

    private static native void setTelemetry(long var0, long var2, boolean var4) throws OrtException;

    static {
        try {
            OnnxRuntime.init();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load onnx-runtime library", e);
        }
        refCount = new AtomicInteger();
    }
}

