/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.engine;

import ai.djl.Device;
import ai.djl.mxnet.engine.MxNDManager;
import ai.djl.mxnet.jna.JnaUtils;
import ai.djl.ndarray.types.Shape;
import ai.djl.util.NativeResource;
import ai.djl.util.PairList;
import ai.djl.util.Utils;
import com.sun.jna.Pointer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class Symbol
extends NativeResource<Pointer> {
    private String[] outputs;
    private MxNDManager manager;

    Symbol(MxNDManager manager, Pointer pointer) {
        super((Object)pointer);
        this.manager = manager;
        manager.attach(this.getUid(), (AutoCloseable)((Object)this));
    }

    public static Symbol load(MxNDManager manager, String path) {
        Pointer pointer = JnaUtils.createSymbolFromFile(path);
        return new Symbol(manager, pointer);
    }

    public String[] getArgNames() {
        return JnaUtils.listSymbolArguments((Pointer)this.getHandle());
    }

    public String[] getAuxNames() {
        return JnaUtils.listSymbolAuxiliaryStates((Pointer)this.getHandle());
    }

    public String[] getAllNames() {
        return JnaUtils.listSymbolNames((Pointer)this.getHandle());
    }

    public String[] getOutputNames() {
        if (this.outputs == null) {
            this.outputs = JnaUtils.listSymbolOutputs((Pointer)this.getHandle());
        }
        return this.outputs;
    }

    private String[] getInternalOutputNames() {
        return JnaUtils.listSymbolOutputs((Pointer)this.getInternals().getHandle());
    }

    public Symbol copy() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Symbol get(int index) {
        Pointer pointer = JnaUtils.getSymbolOutput((Pointer)this.getInternals().getHandle(), index);
        return new Symbol(this.manager, pointer);
    }

    public Symbol get(String name) {
        Object[] out = this.getInternalOutputNames();
        int index = Utils.indexOf((Object[])out, (Object)name);
        if (index < 0) {
            throw new IllegalArgumentException("Cannot find output that matches name: " + name);
        }
        return this.get(index);
    }

    public Symbol getInternals() {
        Pointer pointer = JnaUtils.getSymbolInternals((Pointer)this.getHandle());
        return new Symbol(this.manager, pointer);
    }

    public List<String> getLayerNames() {
        String[] outputNames = this.getInternalOutputNames();
        String[] allNames = this.getAllNames();
        LinkedHashSet<String> allNamesSet = new LinkedHashSet<String>(Arrays.asList(allNames));
        return Arrays.stream(outputNames).filter(n -> !allNamesSet.contains(n)).collect(Collectors.toList());
    }

    public Map<String, Shape> inferShape(PairList<String, Shape> pairs) {
        int i;
        List<List<Shape>> shapes = JnaUtils.inferShape(this, pairs);
        if (shapes == null) {
            throw new IllegalArgumentException("Cannot infer shape based on the data provided!");
        }
        List<Shape> argShapes = shapes.get(0);
        List<Shape> outputShapes = shapes.get(1);
        List<Shape> auxShapes = shapes.get(2);
        String[] argNames = this.getArgNames();
        String[] auxNames = this.getAuxNames();
        String[] outputNames = this.getOutputNames();
        ConcurrentHashMap<String, Shape> shapesMap = new ConcurrentHashMap<String, Shape>();
        for (i = 0; i < argNames.length; ++i) {
            shapesMap.put(argNames[i], argShapes.get(i));
        }
        for (i = 0; i < auxNames.length; ++i) {
            shapesMap.put(auxNames[i], auxShapes.get(i));
        }
        for (i = 0; i < outputNames.length; ++i) {
            shapesMap.put(outputNames[i], outputShapes.get(i));
        }
        return shapesMap;
    }

    public Symbol optimizeFor(String backend, Device device) {
        return new Symbol(this.manager, JnaUtils.optimizeFor(this, backend, device));
    }

    public String toString() {
        return Arrays.toString(this.getOutputNames());
    }

    public void close() {
        Pointer pointer = this.handle.getAndSet(null);
        if (pointer != null) {
            this.manager.detach(this.getUid());
            JnaUtils.freeSymbol(pointer);
            this.manager = null;
        }
    }
}

