/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.engine;

import ai.djl.MalformedModelException;
import ai.djl.mxnet.engine.CachedOp;
import ai.djl.mxnet.engine.MxNDManager;
import ai.djl.mxnet.engine.Symbol;
import ai.djl.mxnet.jna.JnaUtils;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.nn.Block;
import ai.djl.nn.Parameter;
import ai.djl.nn.ParameterBlock;
import ai.djl.nn.ParameterType;
import ai.djl.nn.SymbolBlock;
import ai.djl.training.ParameterStore;
import ai.djl.util.PairList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MxSymbolBlock
extends ParameterBlock
implements SymbolBlock {
    private static final byte VERSION = 2;
    private NDManager manager;
    private CachedOp op;
    private Symbol symbol;
    private List<Parameter> params;
    private Map<String, Shape> paramShapes;
    private Shape[] outputShapes;

    public MxSymbolBlock(NDManager manager, Symbol symbol) {
        this.manager = manager;
        this.symbol = symbol;
        this.inputNames = new ArrayList();
        String[] allNames = symbol.getAllNames();
        this.params = new ArrayList<Parameter>(allNames.length);
        HashSet<String> auxNameSet = new HashSet<String>(Arrays.asList(symbol.getAuxNames()));
        for (String name : allNames) {
            ParameterType type = MxSymbolBlock.inferType(name);
            boolean requireGrad = !auxNameSet.contains(name);
            this.params.add(new Parameter(name, (Block)this, type, requireGrad));
        }
    }

    public void setInputNames(List<String> inputNames) {
        this.inputNames = inputNames;
    }

    public List<Parameter> getAllParameters() {
        return this.params;
    }

    public Shape[] initialize(NDManager manager, DataType dataType, Shape ... inputShapes) {
        this.beforeInitialize(inputShapes);
        for (Parameter parameter : this.params) {
            if (this.inputNames.contains(parameter.getName())) continue;
            parameter.initialize(manager, dataType, inputShapes);
        }
        return this.getOutputShapes(manager, inputShapes);
    }

    public List<String> getLayerNames() {
        return this.symbol.getLayerNames();
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public PairList<String, Shape> describeInput() {
        PairList inputData = new PairList();
        for (String name : this.inputNames) {
            inputData.add((Object)name, (Object)new Shape(new long[0]));
        }
        return inputData;
    }

    public NDList forward(ParameterStore parameterStore, NDList inputs, boolean training, PairList<String, Object> params) {
        if (this.op == null) {
            this.op = JnaUtils.createCachedOp(this, (MxNDManager)this.manager);
        }
        return this.op.forward(parameterStore, inputs);
    }

    public Shape[] getOutputShapes(NDManager manager, Shape[] inputShapes) {
        if (this.outputShapes == null) {
            String[] outputNames = this.symbol.getOutputNames();
            this.outputShapes = new Shape[outputNames.length];
            for (int i = 0; i < this.outputShapes.length; ++i) {
                this.outputShapes[i] = this.getParameterShape(outputNames[i], inputShapes);
            }
        }
        return this.outputShapes;
    }

    public List<Parameter> getDirectParameters() {
        return this.params.stream().filter(p -> !this.inputNames.contains(p.getName())).collect(Collectors.toList());
    }

    public void removeLastBlock() {
        List<String> layerNames = this.getLayerNames();
        String layerName = layerNames.get(layerNames.size() - 2);
        Symbol sliced = this.symbol.get(layerName);
        this.symbol.close();
        this.symbol = sliced;
        HashSet<String> set = new HashSet<String>(Arrays.asList(this.symbol.getAllNames()));
        for (int i = this.params.size() - 1; i >= 0; --i) {
            Parameter parameter = this.params.get(i);
            if (set.contains(parameter.getName())) continue;
            this.params.remove(i).close();
        }
    }

    public Shape getParameterShape(String name, Shape[] inputShapes) {
        if (this.paramShapes == null) {
            PairList pairs = new PairList();
            for (int i = 0; i < this.inputNames.size(); ++i) {
                pairs.add(this.inputNames.get(i), (Object)inputShapes[i]);
            }
            this.paramShapes = this.symbol.inferShape((PairList<String, Shape>)pairs);
        }
        if (this.paramShapes.containsKey(name)) {
            return this.paramShapes.get(name);
        }
        throw new IllegalArgumentException("Name " + name + " not found");
    }

    public void saveParameters(DataOutputStream os) throws IOException {
        os.writeByte(2);
        int size = this.inputNames.size();
        os.writeInt(size);
        for (String name : this.inputNames) {
            os.writeUTF(name);
        }
        for (Parameter parameter : this.params) {
            if (this.inputNames.contains(parameter.getName())) continue;
            parameter.save(os);
        }
    }

    public void loadParameters(NDManager manager, DataInputStream is) throws IOException, MalformedModelException {
        byte version = is.readByte();
        if (version != 2) {
            throw new MalformedModelException("Unsupported encoding version: " + version);
        }
        int size = is.readInt();
        for (int i = 0; i < size; ++i) {
            this.inputNames.add(is.readUTF());
        }
        for (Parameter parameter : this.params) {
            if (this.inputNames.contains(parameter.getName())) continue;
            parameter.load(this.manager, is);
        }
    }

    private static ParameterType inferType(String name) {
        if (name.endsWith("bias")) {
            return ParameterType.BIAS;
        }
        if (name.endsWith("gamma")) {
            return ParameterType.GAMMA;
        }
        if (name.endsWith("beta")) {
            return ParameterType.BETA;
        }
        if (name.endsWith("moving_mean") || name.endsWith("running_mean")) {
            return ParameterType.RUNNING_MEAN;
        }
        if (name.endsWith("moving_var") || name.endsWith("running_var")) {
            return ParameterType.RUNNING_VAR;
        }
        return ParameterType.OTHER;
    }
}

