/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.jna;

import ai.djl.util.cuda.CudaUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class Platform {
    private static final String DEFAULT_VERSION = "1.6.0";
    private String version;
    private String osPrefix;
    private String flavor;
    private String cudaArch;
    private String[] libraries;
    private boolean placeholder;

    Platform() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Win")) {
            this.osPrefix = "win";
        } else if (osName.startsWith("Mac")) {
            this.osPrefix = "osx";
        } else if (osName.startsWith("Linux")) {
            this.osPrefix = "linux";
        } else {
            throw new AssertionError((Object)("Unsupported platform: " + osName));
        }
        if (CudaUtils.getGpuCount() > 0) {
            this.flavor = "cu" + CudaUtils.getCudaVersionString() + "mkl";
            this.cudaArch = CudaUtils.getComputeCapability((int)0);
        } else {
            this.flavor = "mkl";
            this.cudaArch = null;
        }
        this.version = DEFAULT_VERSION;
    }

    public Platform(URL url) throws IOException {
        try (InputStream conf = url.openStream();){
            Properties prop = new Properties();
            prop.load(conf);
            this.version = prop.getProperty("version", DEFAULT_VERSION);
            this.placeholder = prop.getProperty("placeholder") != null;
            String flavorPrefixedClassifier = prop.getProperty("classifier", "");
            this.libraries = prop.getProperty("libraries", "").split(",");
            if (!"".equals(flavorPrefixedClassifier)) {
                this.flavor = flavorPrefixedClassifier.split("-")[0];
                this.osPrefix = flavorPrefixedClassifier.split("-")[1];
            }
        }
    }

    public static Platform fromSystem() {
        return new Platform();
    }

    public String getVersion() {
        return this.version;
    }

    public String getOsPrefix() {
        return this.osPrefix;
    }

    public String getFlavor() {
        return this.flavor;
    }

    public String getClassifier() {
        return this.osPrefix + "-x86_64";
    }

    public String getCudaArch() {
        return this.cudaArch;
    }

    public String[] getLibraries() {
        return this.libraries;
    }

    public boolean isPlaceholder() {
        return this.placeholder;
    }

    public boolean matches(Platform other) {
        if (this.osPrefix == null || other.osPrefix == null) {
            return false;
        }
        return this.osPrefix.equals(other.osPrefix) && this.flavor.equals(other.flavor);
    }

    public boolean compatible(Platform other) {
        if (this.osPrefix == null || other.osPrefix == null) {
            return false;
        }
        if (this.flavor.contains("cu") && other.flavor.contains("cu")) {
            return this.osPrefix.equals(other.osPrefix) && this.flavor.equals(other.flavor);
        }
        return this.osPrefix.equals(other.osPrefix);
    }
}

