/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.jna;

import ai.djl.mxnet.jna.MxnetLibrary;
import ai.djl.util.Utils;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibUtils {
    private static final Logger logger = LoggerFactory.getLogger(LibUtils.class);
    private static final String LIB_NAME = "mxnet";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+\\.\\d+(-[a-z]+)?)(-SNAPSHOT)?(-\\d+)?");

    private LibUtils() {
    }

    public static MxnetLibrary loadLibrary() {
        String libName = LibUtils.getLibName();
        logger.debug("Loading mxnet library from: {}", (Object)libName);
        if (System.getProperty("os.name").startsWith("Linux")) {
            ConcurrentHashMap<String, Integer> options = new ConcurrentHashMap<String, Integer>();
            int rtld = 1;
            options.put("open-flags", rtld);
            return (MxnetLibrary)Native.load((String)libName, MxnetLibrary.class, options);
        }
        return (MxnetLibrary)Native.load((String)libName, MxnetLibrary.class);
    }

    public static String getLibName() {
        String libName = LibUtils.findOverrideLibrary();
        if (libName == null && (libName = LibUtils.findLibraryInClasspath()) == null) {
            libName = LIB_NAME;
        }
        return libName;
    }

    private static String findOverrideLibrary() {
        String libName;
        String libPath = System.getenv("MXNET_LIBRARY_PATH");
        if (libPath != null && (libName = LibUtils.findLibraryInPath(libPath)) != null) {
            return libName;
        }
        libPath = System.getProperty("java.library.path");
        if (libPath != null) {
            return LibUtils.findLibraryInPath(libPath);
        }
        return null;
    }

    private static synchronized String findLibraryInClasspath() {
        Enumeration<URL> urls;
        try {
            urls = Thread.currentThread().getContextClassLoader().getResources("native/lib/mxnet.properties");
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
            return null;
        }
        if (!urls.hasMoreElements()) {
            logger.debug("mxnet.properties not found in class path.");
            return null;
        }
        ai.djl.util.Platform systemPlatform = ai.djl.util.Platform.fromSystem();
        try {
            ai.djl.util.Platform matching = null;
            ai.djl.util.Platform placeholder = null;
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                ai.djl.util.Platform platform = ai.djl.util.Platform.fromUrl((URL)url);
                if (platform.isPlaceholder()) {
                    placeholder = platform;
                    continue;
                }
                if (!platform.matches(systemPlatform)) continue;
                matching = platform;
                break;
            }
            if (matching != null) {
                return LibUtils.loadLibraryFromClasspath(matching);
            }
            if (placeholder != null) {
                try {
                    return LibUtils.downloadMxnet(placeholder);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to download MXNet native library", e);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read MXNet native library jar properties", e);
        }
        throw new IllegalStateException("Your MXNet native library jar does not match your operating system. Make sure that the Maven Dependency Classifier matches your system type.");
    }

    private static String loadLibraryFromClasspath(ai.djl.util.Platform platform) {
        String string;
        block25: {
            Path tmp = null;
            try {
                String libName = System.mapLibraryName(LIB_NAME);
                Path cacheFolder = Utils.getEngineCacheDir((String)LIB_NAME);
                String version = platform.getVersion();
                String flavor = platform.getFlavor();
                if ("cpu".equals(flavor)) {
                    flavor = "mkl";
                } else if (!flavor.endsWith("mkl")) {
                    flavor = flavor + "mkl";
                }
                String classifier = platform.getClassifier();
                Path dir = cacheFolder.resolve(version + '-' + flavor + '-' + classifier);
                logger.debug("Using cache dir: {}", (Object)dir);
                Path path = dir.resolve(libName);
                if (Files.exists(path, new LinkOption[0])) {
                    String string2 = path.toAbsolutePath().toString();
                    return string2;
                }
                Files.createDirectories(cacheFolder, new FileAttribute[0]);
                tmp = Files.createTempDirectory(cacheFolder, "tmp", new FileAttribute[0]);
                for (String file : platform.getLibraries()) {
                    String libPath = "/native/lib/" + file;
                    logger.info("Extracting {} to cache ...", (Object)libPath);
                    try (InputStream is = LibUtils.class.getResourceAsStream(libPath);){
                        if (is == null) {
                            throw new IllegalStateException("MXNet library not found: " + libPath);
                        }
                        Files.copy(is, tmp.resolve(file), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                Utils.moveQuietly((Path)tmp, (Path)dir);
                string = path.toAbsolutePath().toString();
                if (tmp == null) break block25;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to extract MXNet native library", e);
            }
            finally {
                if (tmp != null) {
                    Utils.deleteQuietly(tmp);
                }
            }
            Utils.deleteQuietly((Path)tmp);
        }
        return string;
    }

    private static String findLibraryInPath(String libPath) {
        String[] paths = libPath.split(File.pathSeparator);
        List<String> mappedLibNames = Platform.isMac() ? Arrays.asList("libmxnet.dylib", "libmxnet.jnilib", "libmxnet.so") : Collections.singletonList(System.mapLibraryName(LIB_NAME));
        for (String path : paths) {
            File p = new File(path);
            if (!p.exists()) continue;
            for (String name : mappedLibNames) {
                if (p.isFile() && p.getName().endsWith(name)) {
                    return p.getAbsolutePath();
                }
                File file = new File(path, name);
                if (!file.exists() || !file.isFile()) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private static String downloadMxnet(ai.djl.util.Platform platform) throws IOException {
        String version = platform.getVersion();
        String flavor = platform.getFlavor();
        if ("cpu".equals(flavor)) {
            flavor = "mkl";
        } else if (!flavor.endsWith("mkl")) {
            flavor = flavor + "mkl";
        }
        String classifier = platform.getClassifier();
        String cudaArch = platform.getCudaArch();
        String os = platform.getOsPrefix();
        String libName = System.mapLibraryName(LIB_NAME);
        Path cacheFolder = Utils.getEngineCacheDir((String)LIB_NAME);
        logger.debug("Using cache dir: {}", (Object)cacheFolder);
        Path dir = cacheFolder.resolve(version + '-' + flavor + '-' + classifier);
        Path path = dir.resolve(libName);
        if (Files.exists(path, new LinkOption[0])) {
            return path.toAbsolutePath().toString();
        }
        Files.createDirectories(cacheFolder, new FileAttribute[0]);
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Unexpected version: " + version);
        }
        Path tmp = Files.createTempDirectory(cacheFolder, "tmp", new FileAttribute[0]);
        String link = "https://publish.djl.ai/mxnet-" + matcher.group(1);
        try {
            String string;
            try (InputStream is = new URL(link + "/files.txt").openStream();){
                List lines = Utils.readLines((InputStream)is);
                if (cudaArch != null) {
                    if ("win".equals(os)) {
                        if (!lines.contains(os + '/' + flavor + "/mxnet_" + cudaArch + ".dll.gz")) {
                            logger.warn("No matching cuda flavor for {} found: {}/sm_{}.", new Object[]{os, flavor, cudaArch});
                            flavor = "mkl";
                        }
                    } else if ("linux".equals(os)) {
                        if (!lines.contains(os + '/' + flavor + "/libmxnet.so.gz") || LibUtils.notSupported(platform)) {
                            logger.warn("No matching cuda flavor for {} found: {}/sm_{}.", new Object[]{os, flavor, cudaArch});
                            flavor = "mkl";
                        }
                    } else {
                        throw new AssertionError((Object)("Unsupported GPU operating system: " + os));
                    }
                    if ("mkl".equals(flavor) && Files.exists(path = (dir = cacheFolder.resolve(version + '-' + flavor + '-' + classifier)).resolve(libName), new LinkOption[0])) {
                        String string2 = path.toAbsolutePath().toString();
                        return string2;
                    }
                }
                for (String line : lines) {
                    if (!line.startsWith(os + "/common/") && !line.startsWith(os + '/' + flavor + '/')) continue;
                    URL url = new URL(link + '/' + line);
                    String fileName = line.substring(line.lastIndexOf(47) + 1, line.length() - 3);
                    if ("win".equals(os)) {
                        if ("libmxnet.dll".equals(fileName)) {
                            fileName = "mxnet.dll";
                        } else if (fileName.startsWith("mxnet_")) {
                            if (!("mxnet_" + cudaArch + ".dll").equals(fileName)) continue;
                            fileName = "mxnet.dll";
                        }
                    }
                    logger.info("Downloading {} ...", (Object)fileName);
                    GZIPInputStream fis = new GZIPInputStream(url.openStream());
                    Throwable throwable = null;
                    try {
                        Files.copy(fis, tmp.resolve(fileName), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fis == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)fis).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)fis).close();
                    }
                }
                Utils.moveQuietly((Path)tmp, (Path)dir);
                string = path.toAbsolutePath().toString();
            }
            return string;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Utils.deleteQuietly((Path)tmp);
        }
    }

    private static boolean notSupported(ai.djl.util.Platform platform) {
        if (platform.getVersion().startsWith("1.8.")) {
            String flavor = platform.getFlavor();
            String cudaArch = platform.getCudaArch();
            if ("cu110".equals(flavor)) {
                return !Arrays.asList("50", "60", "70", "80").contains(cudaArch);
            }
            if ("cu102".equals(flavor)) {
                return !Arrays.asList("30", "50", "60", "70", "75").contains(cudaArch);
            }
        }
        return false;
    }
}

