/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.fasttext.engine;

import ai.djl.Device;
import ai.djl.Model;
import ai.djl.fasttext.dataset.FtDataset;
import ai.djl.fasttext.engine.FtModel;
import ai.djl.fasttext.engine.FtTrainingConfig;
import ai.djl.metric.Metrics;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.Shape;
import ai.djl.training.GradientCollector;
import ai.djl.training.Trainer;
import ai.djl.training.TrainingConfig;
import ai.djl.training.dataset.Batch;
import ai.djl.training.evaluator.Evaluator;
import ai.djl.training.loss.Loss;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import org.bytedeco.javacpp.PointerPointer;

public class FtTrainer
implements Trainer {
    private FtModel model;
    private FtTrainingConfig config;
    private Metrics metrics;

    FtTrainer(FtModel model, TrainingConfig trainingConfig) {
        this.model = model;
        this.config = (FtTrainingConfig)trainingConfig;
    }

    public void fit(FtDataset trainingSet, FtDataset validateSet) throws IOException {
        Path outputDir = this.config.getOutputDir();
        if (Files.notExists(outputDir, new LinkOption[0])) {
            Files.createDirectory(outputDir, new FileAttribute[0]);
        }
        String modelName = this.config.getModelName();
        Path modelFile = outputDir.resolve(modelName).toAbsolutePath();
        String[] args = this.config.toCommand(trainingSet.getInputFile().toString());
        this.model.fta.runCmd(args.length, new PointerPointer(args));
        this.model.setModelFile(modelFile);
    }

    public void initialize(Shape ... shapes) {
    }

    public GradientCollector newGradientCollector() {
        throw new UnsupportedOperationException("Fasttest doesn't support AutoGrad");
    }

    public void trainBatch(Batch batch) {
    }

    public NDList forward(NDList input) {
        return null;
    }

    public void validateBatch(Batch batch) {
    }

    public void step() {
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    public List<Device> getDevices() {
        return Collections.emptyList();
    }

    public void endEpoch() {
    }

    public Loss getLoss() {
        return null;
    }

    public Model getModel() {
        return this.model;
    }

    public List<Evaluator> getEvaluators() {
        return null;
    }

    public final <T extends Evaluator> T getEvaluator(Class<T> clazz) {
        return null;
    }

    public NDManager getManager() {
        return null;
    }

    public void close() {
    }
}

