/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.fasttext.dataset;

import ai.djl.ndarray.NDManager;
import ai.djl.repository.Artifact;
import ai.djl.repository.Repository;
import ai.djl.repository.dataset.ZooDataset;
import ai.djl.training.dataset.Batch;
import ai.djl.training.dataset.Dataset;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;

public abstract class FtDataset
implements Dataset,
ZooDataset {
    protected Repository repository;
    protected Dataset.Usage usage;
    private Artifact artifact;
    private boolean prepared;

    public Path getInputFile() throws IOException {
        Artifact.Item item;
        this.prepare(null);
        Map map = this.artifact.getFiles();
        switch (this.usage) {
            case TRAIN: {
                item = (Artifact.Item)map.get("train");
                break;
            }
            case TEST: {
                item = (Artifact.Item)map.get("test");
                break;
            }
            default: {
                item = (Artifact.Item)map.get("validation");
            }
        }
        return this.repository.getFile(item, "").toAbsolutePath();
    }

    public Iterable<Batch> getData(NDManager manager) {
        return null;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Dataset.Usage getUsage() {
        return this.usage;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public void setPrepared(boolean prepared) {
        this.prepared = prepared;
    }

    public void useDefaultArtifact() throws IOException {
        this.artifact = this.repository.resolve(this.getMrl(), "1.0", null);
    }

    public void prepareData(Dataset.Usage usage) {
    }
}

