/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset;

import ai.djl.Application;
import ai.djl.basicdataset.BasicDatasets;
import ai.djl.basicdataset.CsvDataset;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.Resource;
import ai.djl.training.dataset.Dataset;
import ai.djl.util.JsonUtils;
import ai.djl.util.Progress;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.csv.CSVFormat;

public class AmesRandomAccess
extends CsvDataset {
    private static final String ARTIFACT_ID = "ames";
    private Dataset.Usage usage;
    private Resource resource;
    private boolean prepared;

    AmesRandomAccess(Builder builder) {
        super(builder);
        this.usage = builder.usage;
        MRL mrl = MRL.dataset((Application)Application.Tabular.ANY, (String)builder.groupId, (String)builder.artifactId);
        this.resource = new Resource(builder.repository, mrl, "1.0");
    }

    @Override
    public void prepare(Progress progress) throws IOException {
        Path csvFile;
        if (this.prepared) {
            return;
        }
        Artifact artifact = this.resource.getDefaultArtifact();
        this.resource.prepare(artifact, progress);
        Path dir = this.resource.getRepository().getResourceDirectory(artifact);
        Path root = dir.resolve("house-prices-advanced-regression-techniques");
        switch (this.usage) {
            case TRAIN: {
                csvFile = root.resolve("train.csv");
                break;
            }
            case TEST: {
                csvFile = root.resolve("test.csv");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Validation data not available.");
            }
        }
        this.csvUrl = csvFile.toUri().toURL();
        super.prepare(progress);
        this.prepared = true;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class AmesFeatures {
        List<String> featureArray;
        Set<String> categorical;
        Map<String, Map<String, Integer>> featureToMap;

        private AmesFeatures() {
        }
    }

    public static final class Builder
    extends CsvDataset.CsvBuilder<Builder> {
        Repository repository = BasicDatasets.REPOSITORY;
        String groupId = "ai.djl.basicdataset";
        String artifactId = "ames";
        Dataset.Usage usage = Dataset.Usage.TRAIN;
        AmesFeatures af;

        Builder() {
            this.csvFormat = CSVFormat.DEFAULT.withFirstRecordAsHeader().withIgnoreHeaderCase().withTrim();
        }

        @Override
        public Builder self() {
            return this;
        }

        public Builder optUsage(Dataset.Usage usage) {
            this.usage = usage;
            return this.self();
        }

        public Builder optRepository(Repository repository) {
            this.repository = repository;
            return this.self();
        }

        public Builder optGroupId(String groupId) {
            this.groupId = groupId;
            return this.self();
        }

        public Builder optArtifactId(String artifactId) {
            if (artifactId.contains(":")) {
                String[] tokens = artifactId.split(":");
                this.groupId = tokens[0];
                this.artifactId = tokens[1];
            } else {
                this.artifactId = artifactId;
            }
            return this.self();
        }

        public Builder addFeature(String name) {
            return this.addFeature(name, false);
        }

        public Builder addFeature(String name, boolean onehotEncode) {
            this.parseFeatures();
            if (this.af.categorical.contains(name)) {
                Map<String, Integer> map = this.af.featureToMap.get(name);
                if (map == null) {
                    return (Builder)((Object)this.addCategoricalFeature(name));
                }
                return (Builder)((Object)this.addCategoricalFeature(name, map, onehotEncode));
            }
            return (Builder)((Object)this.addNumericFeature(name));
        }

        public List<String> getAvailableFeatures() {
            this.parseFeatures();
            return this.af.featureArray;
        }

        @Override
        public AmesRandomAccess build() {
            if (this.features.isEmpty()) {
                this.parseFeatures();
                for (String name : this.af.featureArray) {
                    this.addFeature(name);
                }
            }
            if (this.labels.isEmpty()) {
                this.addNumericLabel("saleprice");
            }
            return new AmesRandomAccess(this);
        }

        private void parseFeatures() {
            if (this.af == null) {
                try (InputStream is = AmesRandomAccess.class.getResourceAsStream("ames.json");
                     InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
                    this.af = (AmesFeatures)JsonUtils.GSON.fromJson((Reader)reader, AmesFeatures.class);
                }
                catch (IOException e) {
                    throw new AssertionError("Failed to read ames.json from classpath", e);
                }
            }
        }
    }
}

