/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset;

import ai.djl.Application;
import ai.djl.basicdataset.BasicDatasets;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.modality.cv.util.BufferedImageUtils;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.Shape;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.dataset.ZooDataset;
import ai.djl.training.dataset.Dataset;
import ai.djl.training.dataset.RandomAccessDataset;
import ai.djl.training.dataset.Record;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PikachuDetection
extends RandomAccessDataset
implements ZooDataset {
    private static final String VERSION = "1.0";
    private static final String ARTIFACT_ID = "pikachu";
    private static final Gson GSON = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").setPrettyPrinting().create();
    private Repository repository;
    private Artifact artifact;
    private Dataset.Usage usage;
    private boolean prepared;
    private NDImageUtils.Flag flag;
    private List<Path> imagePaths;
    private List<float[]> labels;

    protected PikachuDetection(Builder builder) {
        super((RandomAccessDataset.BaseBuilder)builder);
        this.repository = builder.repository;
        this.artifact = builder.artifact;
        this.usage = builder.usage;
        this.flag = builder.flag;
        this.imagePaths = new ArrayList<Path>();
        this.labels = new ArrayList<float[]>();
    }

    public static Builder builder() {
        return new Builder();
    }

    public MRL getMrl() {
        return MRL.dataset((Application)Application.CV.OBJECT_DETECTION, (String)"ai.djl.basicdataset", (String)ARTIFACT_ID);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Dataset.Usage getUsage() {
        return this.usage;
    }

    public boolean isPrepared() {
        return this.prepared;
    }

    public void setPrepared(boolean prepared) {
        this.prepared = prepared;
    }

    public void useDefaultArtifact() throws IOException {
        this.artifact = this.repository.resolve(this.getMrl(), VERSION, null);
    }

    public void prepareData(Dataset.Usage usage) throws IOException {
        Path usagePath;
        Path root = this.repository.getResourceDirectory(this.artifact);
        switch (usage) {
            case TRAIN: {
                usagePath = Paths.get("train", new String[0]);
                break;
            }
            case TEST: {
                usagePath = Paths.get("test", new String[0]);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Validation data not available.");
            }
        }
        usagePath = root.resolve(usagePath);
        Path indexFile = usagePath.resolve("index.file");
        try (BufferedReader reader = Files.newBufferedReader(indexFile);){
            Type mapType = new TypeToken<Map<String, List<Float>>>(){}.getType();
            Map metadata = (Map)GSON.fromJson((Reader)reader, mapType);
            for (Map.Entry entry : metadata.entrySet()) {
                float[] labelArray = new float[5];
                String imgName = (String)entry.getKey();
                List label = (List)entry.getValue();
                labelArray[0] = ((Float)label.get(4)).floatValue();
                labelArray[1] = ((Float)label.get(5)).floatValue();
                labelArray[2] = ((Float)label.get(6)).floatValue();
                labelArray[3] = ((Float)label.get(7)).floatValue();
                labelArray[4] = ((Float)label.get(8)).floatValue();
                this.imagePaths.add(usagePath.resolve(imgName));
                this.labels.add(labelArray);
            }
        }
    }

    public Record get(NDManager manager, long index) throws IOException {
        int idx = Math.toIntExact(index);
        NDList d = new NDList(new NDArray[]{BufferedImageUtils.readFileToArray((NDManager)manager, (Path)this.imagePaths.get(idx), (NDImageUtils.Flag)this.flag)});
        NDArray label = manager.create(this.labels.get(idx));
        NDList l = new NDList(new NDArray[]{label.reshape(new Shape(new long[]{1L}).addAll(label.getShape()))});
        return new Record(d, l);
    }

    protected long availableSize() {
        return this.imagePaths.size();
    }

    public static final class Builder
    extends RandomAccessDataset.BaseBuilder<Builder> {
        Repository repository = BasicDatasets.REPOSITORY;
        Artifact artifact;
        Dataset.Usage usage = Dataset.Usage.TRAIN;
        NDImageUtils.Flag flag = NDImageUtils.Flag.COLOR;

        Builder() {
            this.pipeline = new Pipeline(new Transform[]{new ToTensor()});
        }

        public Builder self() {
            return this;
        }

        public Builder optUsage(Dataset.Usage usage) {
            this.usage = usage;
            return this.self();
        }

        public Builder optRepository(Repository repository) {
            this.repository = repository;
            return this.self();
        }

        public Builder optArtifact(Artifact artifact) {
            this.artifact = artifact;
            return this.self();
        }

        public Builder optFlag(NDImageUtils.Flag flag) {
            this.flag = flag;
            return this.self();
        }

        public PikachuDetection build() {
            return new PikachuDetection(this);
        }
    }
}

