/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset;

import ai.djl.basicdataset.AbstractImageFolder;
import ai.djl.util.Progress;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;

public final class ImageFolder
extends AbstractImageFolder {
    private boolean prepared;

    private ImageFolder(AbstractImageFolder.ImageFolderBuilder<?> builder) {
        super(builder);
        this.loadSynset();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected Path getImagePath(String key) {
        return Paths.get(key, new String[0]);
    }

    public void prepare(Progress progress) {
        if (!this.prepared) {
            File root = new File(this.repository.getBaseUri());
            if (progress != null) {
                progress.reset("Preparing", 2L);
                progress.start(0L);
                this.listImages(root, this.synset);
                progress.end();
            } else {
                this.listImages(root, this.synset);
            }
            this.prepared = true;
        }
    }

    private void loadSynset() {
        File root = new File(this.repository.getBaseUri());
        Object[] dir = root.listFiles(f -> f.isDirectory() && !f.getName().startsWith("."));
        if (dir == null || dir.length == 0) {
            throw new IllegalArgumentException(root + " not found or didn't have any file in it");
        }
        Arrays.sort(dir);
        for (Object file : dir) {
            this.synset.add(((File)file).getName());
        }
    }

    public static final class Builder
    extends AbstractImageFolder.ImageFolderBuilder<Builder> {
        Builder() {
        }

        protected Builder self() {
            return this;
        }

        public ImageFolder build() {
            return new ImageFolder(this);
        }
    }
}

