/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.engine;

import ai.djl.Device;
import ai.djl.Model;
import ai.djl.engine.EngineException;
import ai.djl.engine.EngineProvider;
import ai.djl.ndarray.NDManager;
import ai.djl.training.GradientCollector;
import ai.djl.training.LocalParameterServer;
import ai.djl.training.ParameterServer;
import ai.djl.training.optimizer.Optimizer;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Engine {
    private static final Logger logger = LoggerFactory.getLogger(Engine.class);
    private static final Map<String, Engine> ALL_ENGINES = new ConcurrentHashMap<String, Engine>();
    private static final String DEFAULT_ENGINE = Engine.initEngine();

    private static synchronized String initEngine() {
        ServiceLoader<EngineProvider> loaders = ServiceLoader.load(EngineProvider.class);
        for (EngineProvider provider : loaders) {
            Engine engine = provider.getEngine();
            if (engine != null) {
                logger.debug("Engine loaded from provider: {}", (Object)engine.getEngineName());
                ALL_ENGINES.put(engine.getEngineName(), engine);
                continue;
            }
            logger.warn("Failed to load engine from: {}", (Object)provider.getClass().getName());
        }
        if (ALL_ENGINES.isEmpty()) {
            logger.debug("No engine found from EngineProvider");
            return null;
        }
        String defaultEngine = System.getenv("DJL_DEFAULT_ENGINE");
        if ((defaultEngine = System.getProperty("ai.djl.default_engine", defaultEngine)) == null || defaultEngine.isEmpty()) {
            if (ALL_ENGINES.size() > 1) {
                logger.warn("More than one deep learning engines found.");
            }
            int rank = Integer.MAX_VALUE;
            for (Engine engine : ALL_ENGINES.values()) {
                if (engine.getRank() >= rank) continue;
                defaultEngine = engine.getEngineName();
                rank = engine.getRank();
            }
        } else if (!ALL_ENGINES.containsKey(defaultEngine)) {
            throw new EngineException("Unknown default engine: " + defaultEngine);
        }
        logger.debug("Found default engine: {}", (Object)defaultEngine);
        return defaultEngine;
    }

    public abstract String getEngineName();

    public int getRank() {
        return 1;
    }

    public static Engine getInstance() {
        if (DEFAULT_ENGINE == null) {
            throw new EngineException("No deep learning engine found." + System.lineSeparator() + "Please refer to https://github.com/awslabs/djl/blob/master/docs/development/troubleshooting.md for more details.");
        }
        return Engine.getEngine(System.getProperty("ai.djl.default_engine", DEFAULT_ENGINE));
    }

    public static boolean hasEngine(String engineName) {
        return ALL_ENGINES.containsKey(engineName);
    }

    public static Set<String> getAllEngines() {
        return ALL_ENGINES.keySet();
    }

    public static Engine getEngine(String engineName) {
        Engine engine = ALL_ENGINES.get(engineName);
        if (engine == null) {
            throw new IllegalArgumentException("Deep learning engine not found: " + engineName);
        }
        return engine;
    }

    public abstract String getVersion();

    public abstract boolean hasCapability(String var1);

    public abstract Model newModel(String var1, Device var2);

    public abstract NDManager newBaseManager();

    public abstract NDManager newBaseManager(Device var1);

    public abstract GradientCollector newGradientCollector();

    public ParameterServer newParameterServer(Optimizer optimizer) {
        return new LocalParameterServer(optimizer);
    }

    public abstract void setRandomSeed(int var1);

    public void debugEnvironment() {
        logger.info("Engine name: {}", (Object)this.getEngineName());
        logger.info("Engine version: {}", (Object)this.getVersion());
    }
}

