/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv;

import ai.djl.modality.cv.Image;
import ai.djl.ndarray.NDArray;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;

public abstract class ImageFactory {
    private static ImageFactory factory = ImageFactory.newInstance();

    private static ImageFactory newInstance() {
        String className = "ai.djl.modality.cv.BufferedImageFactory";
        if (System.getProperty("java.vendor.url").equals("http://www.android.com/")) {
            className = "ai.djl.android.core.BitmapImageFactory";
        }
        try {
            Class<ImageFactory> clazz = Class.forName(className).asSubclass(ImageFactory.class);
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Create new ImageFactory failed!", e);
        }
    }

    public static ImageFactory getInstance() {
        return factory;
    }

    public static void setImageFactory(ImageFactory factory) {
        ImageFactory.factory = factory;
    }

    public abstract Image fromFile(Path var1) throws IOException;

    public abstract Image fromUrl(URL var1) throws IOException;

    public Image fromUrl(String url) throws IOException {
        URI uri = URI.create(url);
        if (uri.isAbsolute()) {
            return this.fromUrl(uri.toURL());
        }
        return this.fromFile(Paths.get(url, new String[0]));
    }

    public abstract Image fromInputStream(InputStream var1) throws IOException;

    public abstract Image fromImage(Object var1);

    public abstract Image fromNDArray(NDArray var1);
}

