/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.optimizer;

import ai.djl.Device;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.internal.NDArrayEx;
import ai.djl.training.optimizer.Optimizer;
import ai.djl.training.optimizer.learningrate.LearningRateTracker;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Adam
extends Optimizer {
    private LearningRateTracker learningRateTracker;
    private float beta1;
    private float beta2;
    private float epsilon;
    private Map<String, Map<Device, NDArray>> means;
    private Map<String, Map<Device, NDArray>> variances;

    protected Adam(Builder builder) {
        super(builder);
        this.learningRateTracker = builder.learningRateTracker;
        this.beta1 = builder.beta1;
        this.beta2 = builder.beta2;
        this.epsilon = builder.epsilon;
        this.means = new ConcurrentHashMap<String, Map<Device, NDArray>>();
        this.variances = new ConcurrentHashMap<String, Map<Device, NDArray>>();
    }

    @Override
    public void update(String parameterId, NDArray weight, NDArray grad) {
        int t = this.updateCount(parameterId);
        double coef1 = 1.0 - Math.pow(this.beta1, t);
        double coef2 = 1.0 - Math.pow(this.beta2, t);
        float lr = this.learningRateTracker.getNewLearningRate(t);
        float newLearningRate = (float)((double)lr * Math.sqrt(coef2) / coef1);
        float weightDecay = this.getWeightDecay();
        if (Float.isNaN(newLearningRate) || Float.isNaN(weightDecay) || Float.isInfinite(newLearningRate) || Float.isInfinite(weightDecay)) {
            throw new IllegalStateException("learning rate or weight decay is nan or infinite");
        }
        NDList inputs = new NDList(weight, grad, this.withDefaultState(this.means, parameterId, weight.getDevice(), k -> weight.zerosLike()), this.withDefaultState(this.variances, parameterId, weight.getDevice(), k -> weight.zerosLike()));
        NDList weights = new NDList(weight);
        NDArrayEx ex = weight.getNDArrayInternal();
        ex.adamUpdate(inputs, weights, newLearningRate, weightDecay, this.rescaleGrad, this.clipGrad, this.beta1, this.beta2, this.epsilon, true);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends Optimizer.OptimizerBuilder<Builder> {
        private LearningRateTracker learningRateTracker = LearningRateTracker.fixedLearningRate(0.001f);
        private float beta1 = 0.9f;
        private float beta2 = 0.999f;
        private float epsilon = 1.0E-8f;

        Builder() {
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder optLearningRateTracker(LearningRateTracker learningRateTracker) {
            this.learningRateTracker = learningRateTracker;
            return this;
        }

        public Builder optBeta1(float beta1) {
            this.beta1 = beta1;
            return this;
        }

        public Builder optBeta2(float beta2) {
            this.beta2 = beta2;
            return this;
        }

        public Builder optEpsilon(float epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        public Adam build() {
            return new Adam(this);
        }
    }
}

