/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.evaluator;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.types.DataType;
import ai.djl.training.evaluator.AbstractAccuracy;
import ai.djl.util.Pair;

public class Accuracy
extends AbstractAccuracy {
    public Accuracy() {
        this("Accuracy", 0, 1);
    }

    public Accuracy(String name, int index) {
        super(name, index);
    }

    public Accuracy(String name, int index, int axis) {
        super(name, index, axis);
    }

    @Override
    protected Pair<Long, NDArray> accuracyHelper(NDList labels, NDList predictions) {
        NDArray label = (NDArray)labels.get(this.index);
        NDArray prediction = (NDArray)predictions.get(this.index);
        this.checkLabelShapes(label, prediction);
        NDArray predictionReduced = !label.getShape().equals(prediction.getShape()) ? prediction.argMax(this.axis) : prediction;
        long total = label.size();
        try (NDArray nd = label.toType(DataType.INT64, false);){
            NDArray correct = predictionReduced.toType(DataType.INT64, false).eq(nd).countNonzero();
            Pair<Long, NDArray> pair = new Pair<Long, NDArray>(total, correct);
            return pair;
        }
    }
}

