/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository.zoo;

import ai.djl.Application;
import ai.djl.MalformedModelException;
import ai.djl.repository.Artifact;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelLoader;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.repository.zoo.ZooProvider;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ModelZoo {
    public String getGroupId();

    default public List<ModelLoader<?, ?>> getModelLoaders() {
        ArrayList list = new ArrayList();
        try {
            Field[] fields;
            for (Field field : fields = this.getClass().getDeclaredFields()) {
                if (!ModelLoader.class.isAssignableFrom(field.getType())) continue;
                list.add((ModelLoader)field.get(null));
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return list;
    }

    default public ModelLoader<?, ?> getModelLoader(String name) {
        for (ModelLoader<?, ?> loader : this.getModelLoaders()) {
            if (!name.equals(loader.getArtifactId())) continue;
            return loader;
        }
        return null;
    }

    public Set<String> getSupportedEngines();

    public static <I, O> ZooModel<I, O> loadModel(Criteria<I, O> criteria) throws IOException, ModelNotFoundException, MalformedModelException {
        Logger logger = LoggerFactory.getLogger(ModelZoo.class);
        String artifactId = criteria.getArtifactId();
        ModelZoo modelZoo = criteria.getModelZoo();
        String groupId = criteria.getGroupId();
        String engine = criteria.getEngine();
        Application application = criteria.getApplication();
        ArrayList<ModelZoo> list = new ArrayList<ModelZoo>();
        if (modelZoo != null) {
            logger.debug("Searching model in specified model zoo: {}", (Object)modelZoo.getGroupId());
            if (groupId != null && !modelZoo.getGroupId().equals(groupId)) {
                throw new ModelNotFoundException("groupId conflict with ModelZoo criteria.");
            }
            Set<String> supportedEngine = modelZoo.getSupportedEngines();
            if (engine != null && !supportedEngine.contains(engine)) {
                throw new ModelNotFoundException("ModelZoo doesn't support specified with engine: " + engine);
            }
            list.add(modelZoo);
        } else {
            ServiceLoader<ZooProvider> providers = ServiceLoader.load(ZooProvider.class);
            for (ZooProvider provider : providers) {
                logger.debug("Searching model in zoo provider: {}", (Object)provider.getName());
                ModelZoo zoo = provider.getModelZoo();
                if (zoo == null) {
                    logger.debug("No model zoo found in zoo provider: {}", (Object)provider.getName());
                    continue;
                }
                if (groupId != null && !zoo.getGroupId().equals(groupId)) {
                    logger.debug("Ignored ModelZoo by groupId: {}", (Object)zoo.getGroupId());
                    continue;
                }
                Set<String> supportedEngine = zoo.getSupportedEngines();
                if (engine != null && !supportedEngine.contains(engine)) {
                    logger.debug("Ignored ModelZoo by specified engine: {}", (Object)zoo.getGroupId());
                    continue;
                }
                list.add(zoo);
            }
        }
        for (ModelZoo zoo : list) {
            String loaderGroupId = zoo.getGroupId();
            for (ModelLoader<?, ?> loader : zoo.getModelLoaders()) {
                Application app = loader.getApplication();
                String loaderArtifactId = loader.getArtifactId();
                logger.debug("Checking ModelLoader: {} {}:{}", new Object[]{app.getPath(), loaderGroupId, loaderArtifactId});
                if (artifactId != null && !artifactId.equals(loaderArtifactId) || application != null && app != Application.UNDEFINED && !app.equals(application)) continue;
                try {
                    return loader.loadModel(criteria);
                }
                catch (ModelNotFoundException e) {
                    logger.debug("input/output type found for ModelLoader: {} {}:{}", new Object[]{app, groupId, loaderArtifactId});
                }
            }
        }
        throw new ModelNotFoundException("No matching model with specified Input/Output type found.");
    }

    public static Map<Application, List<Artifact>> listModels() throws IOException, ModelNotFoundException {
        TreeMap<Application, List<Artifact>> models = new TreeMap<Application, List<Artifact>>(Comparator.comparing(Application::getPath));
        ServiceLoader<ZooProvider> providers = ServiceLoader.load(ZooProvider.class);
        for (ZooProvider provider : providers) {
            ModelZoo zoo = provider.getModelZoo();
            if (zoo == null) continue;
            List<ModelLoader<?, ?>> list = zoo.getModelLoaders();
            for (ModelLoader<?, ?> loader : list) {
                Application app = loader.getApplication();
                List<Artifact> artifacts = loader.listModels();
                models.compute(app, (key, val) -> {
                    if (val == null) {
                        val = new ArrayList();
                    }
                    val.addAll(artifacts);
                    return val;
                });
            }
        }
        return models;
    }
}

