/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

class Anchor {
    public static final Anchor MODEL = new Anchor("model");
    public static final Anchor DATASET = new Anchor("dataset");
    private String[] path;

    public Anchor(String ... path) {
        this.path = path;
    }

    public static Anchor parse(String anchor) {
        String[] tokens = anchor.split("[:/]");
        return new Anchor(tokens);
    }

    public Anchor normalize() {
        ArrayList parts = new ArrayList();
        for (String s : this.path) {
            String[] tokens = s.split("/");
            Collections.addAll(parts, tokens);
        }
        return new Anchor(parts.toArray(new String[0]));
    }

    public String get(int index) {
        return this.path[index];
    }

    public String getPath() {
        return String.join((CharSequence)"/", this.path);
    }

    public Anchor getParent() {
        String[] parent = Arrays.copyOfRange(this.path, 0, this.path.length - 1);
        return new Anchor(parent);
    }

    public Anchor resolve(Anchor other) {
        String[] newPath = new String[this.path.length + other.path.length];
        System.arraycopy(this.path, 0, newPath, 0, this.path.length);
        System.arraycopy(other.path, 0, newPath, this.path.length, other.path.length);
        return new Anchor(newPath);
    }

    public Anchor resolve(String ... others) {
        Anchor anchor = this;
        for (String other : others) {
            anchor = anchor.resolve(Anchor.parse(other));
        }
        return anchor;
    }
}

