/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training;

import ai.djl.Device;
import ai.djl.Model;
import ai.djl.metric.Metrics;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDArrays;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.Shape;
import ai.djl.nn.Parameter;
import ai.djl.training.DataManager;
import ai.djl.training.GradientCollector;
import ai.djl.training.LocalParameterServer;
import ai.djl.training.ParameterStore;
import ai.djl.training.TrainingConfig;
import ai.djl.training.TrainingResult;
import ai.djl.training.dataset.Batch;
import ai.djl.training.dataset.Dataset;
import ai.djl.training.evaluator.Evaluator;
import ai.djl.training.listener.EpochTrainingListener;
import ai.djl.training.listener.EvaluatorTrainingListener;
import ai.djl.training.listener.TrainingListener;
import ai.djl.training.loss.Loss;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Trainer
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Trainer.class);
    private Model model;
    private NDManager manager;
    private Metrics metrics;
    private List<TrainingListener> listeners;
    private Device[] devices;
    private ParameterStore parameterStore;
    private List<Evaluator> evaluators;
    private Loss loss;
    private DataManager dataManager;
    long batchBeginTime;
    private boolean gradientsChecked;

    public Trainer(Model model, TrainingConfig trainingConfig) {
        this.model = model;
        this.manager = model.getNDManager().newSubManager();
        this.devices = trainingConfig.getDevices();
        this.loss = trainingConfig.getLossFunction();
        this.dataManager = trainingConfig.getDataManager();
        if (this.loss == null) {
            throw new IllegalArgumentException("You must specify a loss for the trainer");
        }
        this.evaluators = new ArrayList<Evaluator>(trainingConfig.getEvaluators());
        this.evaluators.add(this.loss);
        LocalParameterServer parameterServer = new LocalParameterServer(trainingConfig.getOptimizer());
        this.parameterStore = new ParameterStore(this.manager, false);
        this.parameterStore.setParameterServer(parameterServer, this.devices);
        this.listeners = trainingConfig.getTrainingListeners();
        this.listeners.forEach(listener -> listener.onTrainingBegin(this));
    }

    public void initialize(Shape ... shapes) {
        this.model.getBlock().initialize(this.model.getNDManager(), this.model.getDataType(), shapes);
        this.model.getBlock().getParameters().forEach(pair -> {
            for (Device device : this.devices) {
                this.parameterStore.getValue((Parameter)pair.getValue(), device);
            }
        });
    }

    public Iterable<Batch> iterateDataset(Dataset dataset) {
        return dataset.getData(this.getManager());
    }

    public GradientCollector newGradientCollector() {
        return this.manager.getEngine().newGradientCollector();
    }

    public void trainBatch(Batch batch) {
        if (this.manager.getEngine() != batch.getManager().getEngine()) {
            throw new IllegalArgumentException("The data must be on the same engine as the trainer. You may need to change one of your NDManagers.");
        }
        Batch[] splits = batch.split(this.devices, false);
        TrainingListener.BatchData batchData = new TrainingListener.BatchData(batch, new ConcurrentHashMap<Device, NDList>(), new ConcurrentHashMap<Device, NDList>());
        try (GradientCollector collector = this.newGradientCollector();){
            for (Batch split : splits) {
                NDList data = this.dataManager.getData(split);
                NDList labels = this.dataManager.getLabels(split);
                NDList preds = this.forward(data);
                long time = System.nanoTime();
                NDArray lossValue = this.loss.evaluate(labels, preds);
                collector.backward(lossValue);
                this.addMetric("backward", time);
                time = System.nanoTime();
                batchData.getLabels().put(((NDArray)labels.get(0)).getDevice(), labels);
                batchData.getPredictions().put(((NDArray)preds.get(0)).getDevice(), preds);
                this.addMetric("training-metrics", time);
            }
        }
        this.addMetric("train", this.batchBeginTime);
        this.batchBeginTime = System.nanoTime();
        this.listeners.forEach(listener -> listener.onTrainingBatch(this, batchData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NDList forward(NDList input) {
        long begin = System.nanoTime();
        try {
            NDList nDList = this.model.getBlock().forward(this.parameterStore, input, true);
            return nDList;
        }
        finally {
            this.addMetric("forward", begin);
        }
    }

    public NDList predict(NDList input) {
        return this.model.getBlock().forward(this.parameterStore, input, false);
    }

    public void validateBatch(Batch batch) {
        if (this.manager.getEngine() != batch.getManager().getEngine()) {
            throw new IllegalArgumentException("The data must be on the same engine as the trainer. You may need to change one of your NDManagers.");
        }
        long begin = System.nanoTime();
        Batch[] splits = batch.split(this.devices, false);
        TrainingListener.BatchData batchData = new TrainingListener.BatchData(batch, new ConcurrentHashMap<Device, NDList>(), new ConcurrentHashMap<Device, NDList>());
        for (Batch split : splits) {
            NDList data = this.dataManager.getData(split);
            NDList labels = this.dataManager.getLabels(split);
            NDList preds = this.forward(data);
            batchData.getLabels().put(((NDArray)labels.get(0)).getDevice(), labels);
            batchData.getPredictions().put(((NDArray)preds.get(0)).getDevice(), preds);
        }
        this.addMetric("validate", begin);
        this.listeners.forEach(listener -> listener.onValidationBatch(this, batchData));
    }

    public void step() {
        if (!this.gradientsChecked) {
            this.checkGradients();
        }
        long begin = System.nanoTime();
        this.parameterStore.updateAllParameters();
        this.addMetric("step", begin);
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    public List<Device> getDevices() {
        return Arrays.asList(this.devices);
    }

    public void endEpoch() {
        this.listeners.forEach(listener -> listener.onEpoch(this));
    }

    public Loss getLoss() {
        return this.loss;
    }

    public Model getModel() {
        return this.model;
    }

    public List<Evaluator> getEvaluators() {
        return this.evaluators;
    }

    public TrainingResult getTrainingResult() {
        TrainingResult result = new TrainingResult();
        for (TrainingListener listener : this.listeners) {
            if (listener instanceof EpochTrainingListener) {
                result.setEpoch(((EpochTrainingListener)listener).getNumEpochs());
                continue;
            }
            if (!(listener instanceof EvaluatorTrainingListener)) continue;
            EvaluatorTrainingListener l = (EvaluatorTrainingListener)listener;
            result.setEvaluations(l.getLatestEvaluations());
        }
        return result;
    }

    public NDManager getManager() {
        return this.manager;
    }

    protected void finalize() throws Throwable {
        if (this.manager.isOpen()) {
            if (logger.isDebugEnabled()) {
                logger.warn("Model was not closed explicitly: {}", (Object)this.getClass().getSimpleName());
            }
            this.close();
        }
        super.finalize();
    }

    @Override
    public void close() {
        this.listeners.forEach(listener -> listener.onTrainingEnd(this));
        this.parameterStore.sync();
        this.manager.close();
    }

    private void checkGradients() {
        ArrayList grads = new ArrayList();
        this.model.getBlock().getParameters().values().stream().filter(Parameter::requireGradient).forEach(param -> grads.add(this.parameterStore.getValue((Parameter)param, this.devices[0]).getGradient()));
        NDList list = new NDList((NDArray[])grads.stream().map(NDArray::sum).toArray(NDArray[]::new));
        NDArray gradSum = NDArrays.stack(list);
        list.close();
        NDArray array = gradSum.sum();
        float[] sums = array.toFloatArray();
        array.close();
        gradSum.close();
        float sum = 0.0f;
        for (float num : sums) {
            sum += num;
        }
        if (sum == 0.0f) {
            throw new IllegalStateException("Gradient values are all zeros, please call gradientCollector.backward() onyour target NDArray (usually loss), before calling step() ");
        }
        this.gradientsChecked = true;
    }

    private void addMetric(String metricName, long begin) {
        if (this.metrics != null && begin > 0L) {
            this.metrics.addMetric(metricName, System.nanoTime() - begin);
        }
    }
}

