/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository.zoo;

import ai.djl.Model;
import ai.djl.inference.Predictor;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.nn.Block;
import ai.djl.training.Trainer;
import ai.djl.training.TrainingConfig;
import ai.djl.translate.Translator;
import ai.djl.util.PairList;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Function;

public class ZooModel<I, O>
implements Model {
    private Model model;
    private Translator<I, O> translator;

    public ZooModel(Model model, Translator<I, O> translator) {
        this.model = model;
        this.translator = translator;
    }

    @Override
    public void load(Path modelPath, String modelName, Map<String, Object> options) {
        throw new IllegalArgumentException("ZooModel should not be re-loaded.");
    }

    @Override
    public void save(Path modelPath, String modelName) throws IOException {
        this.model.save(modelPath, modelName);
    }

    @Override
    public Block getBlock() {
        return this.model.getBlock();
    }

    @Override
    public void setBlock(Block block) {
        this.model.setBlock(block);
    }

    @Override
    public String getName() {
        return this.model.getName();
    }

    @Override
    public String getProperty(String key) {
        return this.model.getProperty(key);
    }

    @Override
    public void setProperty(String key, String value) {
        this.model.setProperty(key, value);
    }

    @Override
    public Trainer newTrainer(TrainingConfig trainingConfig) {
        return this.model.newTrainer(trainingConfig);
    }

    public Predictor<I, O> newPredictor() {
        return this.newPredictor((Translator)this.translator);
    }

    public <P, Q> Predictor<P, Q> newPredictor(Translator<P, Q> translator) {
        return this.model.newPredictor(translator);
    }

    public Translator<I, O> getTranslator() {
        return this.translator;
    }

    @Override
    public PairList<String, Shape> describeInput() {
        return this.model.describeInput();
    }

    @Override
    public PairList<String, Shape> describeOutput() {
        return this.model.describeOutput();
    }

    @Override
    public String[] getArtifactNames() {
        return this.model.getArtifactNames();
    }

    @Override
    public <T> T getArtifact(String name, Function<InputStream, T> function) throws IOException {
        return this.model.getArtifact(name, function);
    }

    @Override
    public URL getArtifact(String name) throws IOException {
        return this.model.getArtifact(name);
    }

    @Override
    public InputStream getArtifactAsStream(String name) throws IOException {
        return this.model.getArtifactAsStream(name);
    }

    @Override
    public NDManager getNDManager() {
        return this.model.getNDManager();
    }

    @Override
    public void setDataType(DataType dataType) {
        this.model.setDataType(dataType);
    }

    @Override
    public DataType getDataType() {
        return this.model.getDataType();
    }

    @Override
    public void cast(DataType dataType) {
        this.model.cast(dataType);
    }

    @Override
    public void close() {
        this.model.close();
    }
}

