/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.Model;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.translator.BaseImageTranslator;
import ai.djl.ndarray.NDManager;
import ai.djl.util.Utils;
import java.io.IOException;
import java.util.List;

public abstract class ObjectDetectionTranslator
extends BaseImageTranslator<DetectedObjects> {
    protected float threshold;
    protected String synsetArtifactName;
    protected List<String> classes;
    protected double imageWidth;
    protected double imageHeight;

    public ObjectDetectionTranslator(BaseBuilder<?> builder) {
        super(builder);
        this.threshold = builder.threshold;
        this.synsetArtifactName = builder.synsetArtifactName;
        this.classes = builder.classes;
        this.imageWidth = builder.imageWidth;
        this.imageHeight = builder.imageHeight;
    }

    @Override
    public void prepare(NDManager manager, Model model) throws IOException {
        if (this.classes == null) {
            this.classes = model.getArtifact(this.synsetArtifactName, Utils::readLines);
        }
    }

    public static abstract class BaseBuilder<T extends BaseBuilder>
    extends BaseImageTranslator.BaseBuilder<T> {
        protected float threshold = 0.2f;
        protected String synsetArtifactName;
        protected List<String> classes;
        protected double imageWidth;
        protected double imageHeight;

        @Override
        protected abstract T self();

        protected void validate() {
            if (this.synsetArtifactName == null && this.classes == null) {
                throw new IllegalArgumentException("You must specify a synset artifact name or classes");
            }
            if (this.synsetArtifactName != null && this.classes != null) {
                throw new IllegalArgumentException("You can only specify one of: synset artifact name or classes");
            }
        }

        public T optThreshold(float threshold) {
            this.threshold = threshold;
            return (T)this.self();
        }

        public T setSynsetArtifactName(String synsetArtifactName) {
            this.synsetArtifactName = synsetArtifactName;
            return (T)this.self();
        }

        public T setClasses(List<String> classes) {
            this.classes = classes;
            return (T)this.self();
        }

        public T optRescaleSize(double imageWidth, double imageHeight) {
            this.imageWidth = imageWidth;
            this.imageHeight = imageHeight;
            return (T)this.self();
        }

        public float getThreshold() {
            return this.threshold;
        }

        public String getSynsetArtifactName() {
            return this.synsetArtifactName;
        }

        public List<String> getClasses() {
            return this.classes;
        }

        public double getImageWidth() {
            return this.imageWidth;
        }

        public double getImageHeight() {
            return this.imageHeight;
        }
    }
}

