/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import javax.imageio.ImageIO;

public class BufferedImageFactory
extends ImageFactory {
    @Override
    public Image fromFile(Path path) throws IOException {
        BufferedImage image = ImageIO.read(path.toFile());
        if (image == null) {
            throw new IOException("Failed to read image from: " + path);
        }
        return new BufferedImageWrapper(image);
    }

    @Override
    public Image fromUrl(URL url) throws IOException {
        BufferedImage image = ImageIO.read(url);
        if (image == null) {
            throw new IOException("Failed to read image from: " + url);
        }
        return new BufferedImageWrapper(image);
    }

    @Override
    public Image fromInputStream(InputStream is) throws IOException {
        BufferedImage image = ImageIO.read(is);
        if (image == null) {
            throw new IOException("Failed to read image from input stream");
        }
        return new BufferedImageWrapper(image);
    }

    @Override
    public Image fromImage(Object image) {
        if (!(image instanceof BufferedImage)) {
            throw new IllegalArgumentException("only BufferedImage allowed");
        }
        return new BufferedImageWrapper((BufferedImage)image);
    }

    static {
        if (System.getProperty("apple.awt.UIElement") == null) {
            System.setProperty("apple.awt.UIElement", "true");
        }
    }

    static class BufferedImageWrapper
    implements Image {
        private final BufferedImage image;

        BufferedImageWrapper(BufferedImage image) {
            this.image = image;
        }

        @Override
        public int getWidth() {
            return this.image.getWidth();
        }

        @Override
        public int getHeight() {
            return this.image.getHeight();
        }

        @Override
        public Object getWrappedImage() {
            return this.image;
        }

        @Override
        public NDArray toNDArray(NDManager manager, Image.Flag flag) {
            int width = this.image.getWidth();
            int height = this.image.getHeight();
            int channel = flag == Image.Flag.GRAYSCALE ? 1 : 3;
            ByteBuffer bb = manager.allocateDirect(channel * height * width);
            if (this.image.getType() == 10) {
                byte[] data;
                for (byte gray : data = ((DataBufferByte)this.image.getData().getDataBuffer()).getData()) {
                    bb.put(gray);
                    if (flag == Image.Flag.GRAYSCALE) continue;
                    bb.put(gray);
                    bb.put(gray);
                }
            } else {
                int[] pixels;
                for (int rgb : pixels = this.image.getRGB(0, 0, width, height, null, 0, width)) {
                    int red = rgb >> 16 & 0xFF;
                    int green = rgb >> 8 & 0xFF;
                    int blue = rgb & 0xFF;
                    if (flag == Image.Flag.GRAYSCALE) {
                        int gray = (red + green + blue) / 3;
                        bb.put((byte)gray);
                        continue;
                    }
                    bb.put((byte)red);
                    bb.put((byte)green);
                    bb.put((byte)blue);
                }
            }
            bb.rewind();
            return manager.create(bb, new Shape(height, width, channel), DataType.UINT8);
        }

        @Override
        public void save(OutputStream os, String type) throws IOException {
            ImageIO.write((RenderedImage)this.image, type, os);
        }
    }
}

