/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.nn.recurrent;

import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDArrays;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.internal.NDArrayEx;
import ai.djl.nn.Parameter;
import ai.djl.nn.recurrent.RecurrentCell;
import ai.djl.training.ParameterStore;
import ai.djl.util.PairList;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class LSTM
extends RecurrentCell {
    private static final byte VERSION = 2;
    private boolean clipLstmState;
    private double lstmStateClipMin;
    private double lstmStateClipMax;

    LSTM(Builder builder) {
        super(builder);
        this.mode = "lstm";
        this.gates = 4;
        this.clipLstmState = builder.clipLstmState;
        this.lstmStateClipMin = builder.lstmStateClipMin;
        this.lstmStateClipMax = builder.lstmStateClipMax;
    }

    @Override
    public NDList forward(ParameterStore parameterStore, NDList inputs, PairList<String, Object> params) {
        inputs = this.opInputs(parameterStore, inputs);
        NDArrayEx ex = inputs.head().getNDArrayInternal();
        NDList output = this.clipLstmState ? ex.lstm(inputs, this.stateSize, this.dropRate, this.numStackedLayers, this.useSequenceLength, this.isBidirectional(), true, this.lstmStateClipMin, this.lstmStateClipMax, params) : ex.rnn(inputs, this.mode, this.stateSize, this.dropRate, this.numStackedLayers, this.useSequenceLength, this.isBidirectional(), true, params);
        NDList result = new NDList(output.head().transpose(1, 0, 2));
        if (this.stateOutputs) {
            result.add(output.get(1));
        }
        return result;
    }

    @Override
    protected NDList opInputs(ParameterStore parameterStore, NDList inputs) {
        this.validateInputSize(inputs);
        inputs = this.updateInputLayoutToTNC(inputs);
        NDArray head = inputs.head();
        Device device = head.getDevice();
        NDList result = new NDList(head);
        try (NDList parameterList = new NDList();){
            for (Parameter parameter : this.parameters) {
                NDArray array = parameterStore.getValue(parameter, device);
                parameterList.add(array.flatten());
            }
            NDArray array = NDArrays.concat(parameterList);
            result.add(array);
        }
        result.add(inputs.head().getManager().zeros(this.stateShape));
        result.add(inputs.head().getManager().zeros(this.stateShape));
        if (this.useSequenceLength) {
            result.add(inputs.get(1));
        }
        return result;
    }

    @Override
    public void saveParameters(DataOutputStream os) throws IOException {
        os.writeByte(2);
        this.saveInputShapes(os);
        for (Parameter parameter : this.parameters) {
            parameter.save(os);
        }
    }

    @Override
    public void loadParameters(NDManager manager, DataInputStream is) throws IOException, MalformedModelException {
        byte version = is.readByte();
        if (version == 2) {
            this.readInputShapes(is);
        } else if (version != 1) {
            throw new MalformedModelException("Unsupported encoding version: " + version);
        }
        for (Parameter parameter : this.parameters) {
            parameter.load(manager, is);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends RecurrentCell.BaseBuilder<Builder> {
        @Override
        protected Builder self() {
            return this;
        }

        public Builder optLstmStateClipMin(float lstmStateClipMin, float lstmStateClipMax) {
            this.lstmStateClipMin = lstmStateClipMin;
            this.lstmStateClipMax = lstmStateClipMax;
            this.clipLstmState = true;
            return this.self();
        }

        public LSTM build() {
            if (this.stateSize == -1L || this.numStackedLayers == -1) {
                throw new IllegalArgumentException("Must set stateSize and numStackedLayers");
            }
            return new LSTM(this);
        }
    }
}

