/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.Model;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.transform.CenterCrop;
import ai.djl.modality.cv.transform.CenterFit;
import ai.djl.modality.cv.transform.Normalize;
import ai.djl.modality.cv.transform.Pad;
import ai.djl.modality.cv.transform.Resize;
import ai.djl.modality.cv.transform.ResizeShort;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.types.Shape;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class BaseImageTranslator<T>
implements Translator<Image, T> {
    private static final float[] MEAN = new float[]{0.485f, 0.456f, 0.406f};
    private static final float[] STD = new float[]{0.229f, 0.224f, 0.225f};
    protected Pipeline pipeline;
    private Image.Flag flag;
    private Batchifier batchifier;
    protected int width;
    protected int height;

    public BaseImageTranslator(BaseBuilder<?> builder) {
        this.flag = builder.flag;
        this.pipeline = builder.pipeline;
        this.batchifier = builder.batchifier;
        this.width = builder.width;
        this.height = builder.height;
    }

    @Override
    public Batchifier getBatchifier() {
        return this.batchifier;
    }

    @Override
    public NDList processInput(TranslatorContext ctx, Image input) {
        int processedHeight;
        int processedWidth;
        NDArray array = input.toNDArray(ctx.getNDManager(), this.flag);
        NDList list = this.pipeline.transform(new NDList(array));
        Shape shape = ((NDArray)list.get(0)).getShape();
        long[] dim = shape.getShape();
        if (NDImageUtils.isCHW(shape)) {
            processedWidth = (int)dim[dim.length - 1];
            processedHeight = (int)dim[dim.length - 2];
        } else {
            processedWidth = (int)dim[dim.length - 2];
            processedHeight = (int)dim[dim.length - 3];
        }
        ctx.setAttachment("width", input.getWidth());
        ctx.setAttachment("height", input.getHeight());
        ctx.setAttachment("processedWidth", processedWidth);
        ctx.setAttachment("processedHeight", processedHeight);
        return list;
    }

    public static abstract class BaseBuilder<T extends BaseBuilder> {
        protected int width = 224;
        protected int height = 224;
        protected Image.Flag flag = Image.Flag.COLOR;
        protected Pipeline pipeline;
        protected Batchifier batchifier = Batchifier.STACK;

        public T optFlag(Image.Flag flag) {
            this.flag = flag;
            return this.self();
        }

        public T setPipeline(Pipeline pipeline) {
            this.pipeline = pipeline;
            return this.self();
        }

        public T setImageSize(int width, int height) {
            this.width = width;
            this.height = height;
            return this.self();
        }

        public T addTransform(Transform transform) {
            if (this.pipeline == null) {
                this.pipeline = new Pipeline();
            }
            this.pipeline.add(transform);
            return this.self();
        }

        public T optBatchifier(Batchifier batchifier) {
            this.batchifier = batchifier;
            return this.self();
        }

        protected abstract T self();

        protected void validate() {
            if (this.pipeline == null) {
                throw new IllegalArgumentException("pipeline is required.");
            }
        }

        protected void configPreProcess(Map<String, ?> arguments) {
            String normalize;
            String pad;
            if (this.pipeline == null) {
                this.pipeline = new Pipeline();
            }
            this.width = ArgumentsUtil.intValue(arguments, "width", 224);
            this.height = ArgumentsUtil.intValue(arguments, "height", 224);
            if (arguments.containsKey("flag")) {
                this.flag = Image.Flag.valueOf(arguments.get("flag").toString());
            }
            if ("true".equals(pad = ArgumentsUtil.stringValue(arguments, "pad", "false"))) {
                this.addTransform(new Pad(0.0));
            } else if (!"false".equals(pad)) {
                double padding = Double.parseDouble(pad);
                this.addTransform(new Pad(padding));
            }
            String resize = ArgumentsUtil.stringValue(arguments, "resize", "false");
            if ("true".equals(resize)) {
                this.addTransform(new Resize(this.width, this.height));
            } else if (!"false".equals(resize)) {
                String[] tokens = resize.split("\\s*,\\s*");
                int w = (int)Double.parseDouble(tokens[0]);
                int h = tokens.length > 1 ? (int)Double.parseDouble(tokens[1]) : w;
                Image.Interpolation interpolation = tokens.length > 2 ? Image.Interpolation.valueOf(tokens[2]) : Image.Interpolation.BILINEAR;
                this.addTransform(new Resize(w, h, interpolation));
            }
            String resizeShort = ArgumentsUtil.stringValue(arguments, "resizeShort", "false");
            if ("true".equals(resizeShort)) {
                int shortEdge = Math.max(this.width, this.height);
                this.addTransform(new ResizeShort(shortEdge));
            } else if (!"false".equals(resizeShort)) {
                String[] tokens = resizeShort.split("\\s*,\\s*");
                int shortEdge = (int)Double.parseDouble(tokens[0]);
                int longEdge = tokens.length > 1 ? (int)Double.parseDouble(tokens[1]) : -1;
                Image.Interpolation interpolation = tokens.length > 2 ? Image.Interpolation.valueOf(tokens[2]) : Image.Interpolation.BILINEAR;
                this.addTransform(new ResizeShort(shortEdge, longEdge, interpolation));
            }
            if (ArgumentsUtil.booleanValue(arguments, "centerCrop", false)) {
                this.addTransform(new CenterCrop(this.width, this.height));
            }
            if (ArgumentsUtil.booleanValue(arguments, "centerFit")) {
                this.addTransform(new CenterFit(this.width, this.height));
            }
            if (ArgumentsUtil.booleanValue(arguments, "toTensor", true)) {
                this.addTransform(new ToTensor());
            }
            if ("true".equals(normalize = ArgumentsUtil.stringValue(arguments, "normalize", "false"))) {
                this.addTransform(new Normalize(MEAN, STD));
            } else if (!"false".equals(normalize)) {
                String[] tokens = normalize.split("\\s*,\\s*");
                if (tokens.length != 6) {
                    throw new IllegalArgumentException("Invalid normalize value: " + normalize);
                }
                float[] mean = new float[]{Float.parseFloat(tokens[0]), Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2])};
                float[] std = new float[]{Float.parseFloat(tokens[3]), Float.parseFloat(tokens[4]), Float.parseFloat(tokens[5])};
                this.addTransform(new Normalize(mean, std));
            }
            String range = (String)arguments.get("range");
            if ("0,1".equals(range)) {
                this.addTransform(a -> a.div(Float.valueOf(255.0f)));
            } else if ("-1,1".equals(range)) {
                this.addTransform(a -> a.div(Float.valueOf(128.0f)).sub(1));
            }
            if (arguments.containsKey("batchifier")) {
                this.batchifier = Batchifier.fromString((String)arguments.get("batchifier"));
            }
        }

        protected void configPostProcess(Map<String, ?> arguments) {
        }
    }

    protected static final class SynsetLoader {
        private String synsetFileName;
        private URL synsetUrl;
        private List<String> synset;

        public SynsetLoader(List<String> synset) {
            this.synset = synset;
        }

        public SynsetLoader(URL synsetUrl) {
            this.synsetUrl = synsetUrl;
        }

        public SynsetLoader(String synsetFileName) {
            this.synsetFileName = synsetFileName;
        }

        public List<String> load(Model model) throws IOException {
            if (this.synset != null) {
                return this.synset;
            }
            if (this.synsetUrl != null) {
                try (InputStream is = this.synsetUrl.openStream();){
                    List<String> list = Utils.readLines(is);
                    return list;
                }
            }
            return model.getArtifact(this.synsetFileName, Utils::readLines);
        }
    }

    public static abstract class ClassificationBuilder<T extends BaseBuilder>
    extends BaseBuilder<T> {
        protected SynsetLoader synsetLoader;

        public T optSynsetArtifactName(String synsetArtifactName) {
            this.synsetLoader = new SynsetLoader(synsetArtifactName);
            return this.self();
        }

        public T optSynsetUrl(String synsetUrl) {
            try {
                this.synsetLoader = new SynsetLoader(new URL(synsetUrl));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid synsetUrl: " + synsetUrl, e);
            }
            return this.self();
        }

        public T optSynset(List<String> synset) {
            this.synsetLoader = new SynsetLoader(synset);
            return this.self();
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.synsetLoader == null) {
                this.synsetLoader = new SynsetLoader("synset.txt");
            }
            boolean hasCrop = false;
            boolean sizeMismatch = false;
            for (Transform transform : this.pipeline.getTransforms()) {
                if (transform instanceof Resize) {
                    Resize resize = (Resize)transform;
                    if (this.width == resize.getWidth() && this.height == resize.getHeight()) continue;
                    sizeMismatch = true;
                    continue;
                }
                if (!(transform instanceof CenterCrop) && !(transform instanceof CenterFit)) continue;
                hasCrop = true;
            }
            if (sizeMismatch && !hasCrop) {
                throw new IllegalArgumentException("resized image has mismatched target size");
            }
        }

        @Override
        protected void configPostProcess(Map<String, ?> arguments) {
            String synsetFileName;
            String synsetUrl;
            String synset = (String)arguments.get("synset");
            if (synset != null) {
                this.optSynset(Arrays.asList(synset.split(",")));
            }
            if ((synsetUrl = (String)arguments.get("synsetUrl")) != null) {
                this.optSynsetUrl(synsetUrl);
            }
            if ((synsetFileName = (String)arguments.get("synsetFileName")) != null) {
                this.optSynsetArtifactName(synsetFileName);
            }
        }
    }
}

