/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.modality.cv.output.BoundingBox;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.output.Mask;
import ai.djl.modality.cv.translator.BaseImageTranslator;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.types.Shape;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.Transform;
import ai.djl.translate.TranslatorContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InstanceSegmentationTranslator
extends BaseImageTranslator<DetectedObjects> {
    private BaseImageTranslator.SynsetLoader synsetLoader;
    private float threshold;
    private int shortEdge;
    private int maxEdge;
    private int rescaledWidth;
    private int rescaledHeight;
    private List<String> classes;

    public InstanceSegmentationTranslator(Builder builder) {
        super(builder);
        this.synsetLoader = builder.synsetLoader;
        this.threshold = builder.threshold;
        this.shortEdge = builder.shortEdge;
        this.maxEdge = builder.maxEdge;
        this.pipeline.insert(0, null, (Transform)new ResizeShort());
    }

    @Override
    public void prepare(TranslatorContext ctx) throws IOException {
        if (this.classes == null) {
            this.classes = this.synsetLoader.load(ctx.getModel());
        }
    }

    @Override
    public DetectedObjects processOutput(TranslatorContext ctx, NDList list) {
        float[] ids = ((NDArray)list.get(0)).toFloatArray();
        float[] scores = ((NDArray)list.get(1)).toFloatArray();
        NDArray boundingBoxes = (NDArray)list.get(2);
        NDArray masks = (NDArray)list.get(3);
        ArrayList<String> retNames = new ArrayList<String>();
        ArrayList<Double> retProbs = new ArrayList<Double>();
        ArrayList<BoundingBox> retBB = new ArrayList<BoundingBox>();
        for (int i = 0; i < ids.length; ++i) {
            int classId = (int)ids[i];
            double probability = scores[i];
            if (classId < 0 || !(probability > (double)this.threshold)) continue;
            if (classId >= this.classes.size()) {
                throw new AssertionError((Object)("Unexpected index: " + classId));
            }
            String className = this.classes.get(classId);
            float[] box = boundingBoxes.get(i).toFloatArray();
            double x = box[0] / (float)this.rescaledWidth;
            double y = box[1] / (float)this.rescaledHeight;
            double w = (double)(box[2] / (float)this.rescaledWidth) - x;
            double h = (double)(box[3] / (float)this.rescaledHeight) - y;
            NDArray array = masks.get(i);
            Shape maskShape = array.getShape();
            int maskH = (int)maskShape.get(0);
            int maskW = (int)maskShape.get(1);
            float[] flattened = array.toFloatArray();
            float[][] maskFloat = new float[maskH][maskW];
            for (int j = 0; j < maskH; ++j) {
                System.arraycopy(flattened, j * maskW, maskFloat[j], 0, maskW);
            }
            Mask mask = new Mask(x, y, w, h, maskFloat);
            retNames.add(className);
            retProbs.add(probability);
            retBB.add(mask);
        }
        return new DetectedObjects(retNames, retProbs, retBB);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Map<String, ?> arguments) {
        Builder builder = new Builder();
        builder.configPreProcess(arguments);
        builder.configPostProcess(arguments);
        return builder;
    }

    public static class Builder
    extends BaseImageTranslator.ClassificationBuilder<Builder> {
        float threshold = 0.3f;
        int shortEdge = 600;
        int maxEdge = 1000;

        Builder() {
        }

        public Builder optThreshold(float threshold) {
            this.threshold = threshold;
            return this;
        }

        public Builder optShortEdge(int shortEdge) {
            this.shortEdge = shortEdge;
            return this;
        }

        public Builder optMaxEdge(int maxEdge) {
            this.maxEdge = maxEdge;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        protected void configPostProcess(Map<String, ?> arguments) {
            super.configPostProcess(arguments);
            this.threshold = ArgumentsUtil.floatValue(arguments, "threshold", 0.3f);
            this.shortEdge = ArgumentsUtil.intValue(arguments, "shortEdge", 600);
            this.maxEdge = ArgumentsUtil.intValue(arguments, "maxEdge", 1000);
        }

        public InstanceSegmentationTranslator build() {
            this.validate();
            return new InstanceSegmentationTranslator(this);
        }
    }

    private class ResizeShort
    implements Transform {
        private ResizeShort() {
        }

        @Override
        public NDArray transform(NDArray array) {
            Shape shape = array.getShape();
            int width = (int)shape.get(1);
            int height = (int)shape.get(0);
            int min = Math.min(width, height);
            int max = Math.max(width, height);
            float scale = (float)InstanceSegmentationTranslator.this.shortEdge / (float)min;
            if (Math.round(scale * (float)max) > InstanceSegmentationTranslator.this.maxEdge) {
                scale = (float)InstanceSegmentationTranslator.this.maxEdge / (float)max;
            }
            InstanceSegmentationTranslator.this.rescaledHeight = Math.round((float)height * scale);
            InstanceSegmentationTranslator.this.rescaledWidth = Math.round((float)width * scale);
            return NDImageUtils.resize(array, InstanceSegmentationTranslator.this.rescaledWidth, InstanceSegmentationTranslator.this.rescaledHeight);
        }
    }
}

