/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NeuronUtils {
    private static final Logger logger = LoggerFactory.getLogger(NeuronUtils.class);

    private NeuronUtils() {
    }

    public static boolean hasNeuron() {
        return NeuronUtils.getNeuronCores() > 0;
    }

    public static int getNeuronCores() {
        return NeuronUtils.getNeuronCores("/sys/devices/virtual/neuron_device/");
    }

    static int getNeuronCores(String location) {
        Path path = Paths.get(location, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return 0;
        }
        int count = 0;
        try (Stream<Path> dev = Files.list(path);){
            Iterator it = dev.iterator();
            while (it.hasNext()) {
                Path dir = (Path)it.next();
                if (!dir.toFile().getName().startsWith("neuron")) continue;
                Stream<Path> cores = Files.list(dir);
                count += Math.toIntExact(cores.filter(NeuronUtils::matches).count());
                cores.close();
            }
        }
        catch (IOException e) {
            logger.warn("Failed to list neuron cores", (Throwable)e);
        }
        return count;
    }

    private static boolean matches(Path p) {
        return p.getFileName().toString().startsWith("neuron_core");
    }
}

